package ar.com.sdd.gicapi.client.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
public class GicPaymentSet implements Serializable {

    private List<GicPayment> payments;

    public List<GicPayment> getPayments() {
        return payments;
    }

    public void setPayments(List<GicPayment> payments) {
        this.payments = payments;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        GicPaymentSet that = (GicPaymentSet) o;
        return Objects.equals(payments, that.payments);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(payments);
    }

    @Override
    public String toString() {
        return "GicPaymentSet [" +
                ((payments != null) ? "payments=" + Arrays.toString(payments.toArray()) + ", " : "") +
                "]";
    }
}
