package ar.com.sdd.gicapi.client.io;

import ar.com.sdd.gicapi.client.model.Error;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
public class CommonError implements Serializable {

    @JsonProperty("statusCode")
    private Integer statusCode;

    @JsonProperty("message")
    private String message;

    @JsonProperty("error")
    private Error error;

    public Integer getStatusCode() {
        return statusCode;
    }

    public void setStatusCode(Integer statusCode) {
        this.statusCode = statusCode;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Error getError() {
        return error;
    }

    public void setError(Error error) {
        this.error = error;
    }

    @Override
    public String toString() {
        return "CommonError [" +
                ((statusCode != null) ? "statusCode=" + statusCode + ", " : "") +
                ((message != null) ? "message='" + message + "', " : "") +
                ((error != null) ? "error=" + error + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CommonError that = (CommonError) o;
        return Objects.equals(statusCode, that.statusCode) && Objects.equals(message, that.message) && Objects.equals(error, that.error);
    }

    @Override
    public int hashCode() {
        return Objects.hash(statusCode, message, error);
    }
}