package ar.com.sdd.gicapi.client.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
public class GicPaymentMethod implements Serializable {

    private String name;
    private String subtype;
    private String description;

    public GicPaymentMethod(String name, String subtype, String description) {
        this.name = name;
        this.subtype = subtype;
        this.description = description;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSubtype() {
        return subtype;
    }

    public void setSubtype(String subtype) {
        this.subtype = subtype;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String toString() {
        return "GicPaymentMethod [" +
                ((name != null) ? "name='" + name + "', " : "") +
                ((subtype != null) ? "subtype='" + subtype + "', " : "") +
                ((description != null) ? "description='" + description + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        GicPaymentMethod that = (GicPaymentMethod) o;
        return Objects.equals(name, that.name) && Objects.equals(subtype, that.subtype) && Objects.equals(description, that.description);
    }

    @Override
    public int hashCode() {
        return Objects.hash(name, subtype, description);
    }
}