package ar.com.sdd.gicapi.api.payment;

import ar.com.sdd.gicapi.client.model.GicDocumentSet;

import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

public interface GicPaymentApiService {


    /*  Consulta de medios de pagos disponibles para un  payer
     *  return PaymenMethodSet
     */

    Response getPaymentMethods(String authorization, String applicationId, String ownerId, String payerCuit,  SecurityContext securityContext);

    /*  Consulta un screen especifico para obtener deuda
     *  return GicDocumentSet
     */

    Response getDocumentsSet(String authorization, String applicationId, String ownerId, String payerCuit, String screenTemplateName, SecurityContext securityContext);


    /* publica un conjunto de documentos para generar un actionlink con un link de pago
    *  return GicActionLink
    */
    Response postDocumentSetPaymentLink(String authorization, String applicationId, String ownerId, GicDocumentSet documentSet, SecurityContext securityContext);


    /* Busca pagos de un por rango de fechas o referencias
    *  return Collection<GicPayment>
    */
    Response getPayments(String authorization, String applicationId, String ownerId, String fromCreationDate, String toCreationDate, String ownerDocRefList, String legalDocRefList, SecurityContext securityContext);

    /* Consulta status mas conciso de un orderNumber: status, fecha, xx
    *  return GicPaymentStatusInfo
    */
    Response getPaymentStatusInfo(String authorization, String applicationId, String ownerId, String orderNumber, SecurityContext securityContext);

}
