package ar.com.sdd.gicapi.api.auth;

import ar.com.sdd.commons.rest.log.ServerFileLogged;
import ar.com.sdd.commons.rest.model.OAuth2Credential;
import ar.com.sdd.ebfapi.api.auth.AuthEbfApiService;

import javax.inject.Inject;
import javax.ws.rs.*;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path("/gic-api/v1_0/auth")
public class GicAuthEbfApiEndpoint {

    @Inject private AuthEbfApiService authEbfApiService;

    @POST
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/token.oauth2")
    @Consumes({"application/json"})
    @Produces("application/json; charset=utf-8")
    public Response postTokenOauth2(@PathParam("aid") String applicationId, @PathParam("ownerId") String ownerId, OAuth2Credential oauthCredentials, @Context SecurityContext securityContext) {
        return authEbfApiService.postTokenOauth2(applicationId, AuthEbfApiService.OWNER_LOGIN_TYPE.BY_NAME, ownerId, oauthCredentials, securityContext);
    }


}
