package ar.com.sdd.gicapi.api.payment;

import ar.com.sdd.commons.rest.log.ServerFileLogged;
import ar.com.sdd.gicapi.client.model.GicDocumentSet;

import javax.inject.Inject;
import javax.ws.rs.*;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path("/gic-api/v1_0/payment")
public class GicPaymentApiEndpoint {

    @Inject private GicPaymentApiService paymentApiService;

    @GET
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/payerCuit/{payerCuit}/payment-methods")
    @Produces("application/json; charset=utf-8")
    public Response getPaymentMethods(@HeaderParam("Authorization") String authorization, @PathParam("aid") String applicationId, @PathParam("ownerId") String ownerId,
                                    @PathParam("payerCuit") String payerCuit,
                                    @Context SecurityContext securityContext) {

        return paymentApiService.getPaymentMethods(authorization, applicationId, ownerId, payerCuit, securityContext);
    }

    @GET
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/payerCuit/{payerCuit}/document-set/{screenTemplateName}")
    @Produces("application/json; charset=utf-8")
    public Response getDocumentsSet(@HeaderParam("Authorization") String authorization, @PathParam("aid") String applicationId, @PathParam("ownerId") String ownerId,
                                    @PathParam("payerCuit") String payerCuit,@PathParam("screenTemplateName") String screenTemplateName,
                                    @Context SecurityContext securityContext) {

        return paymentApiService.getDocumentsSet(authorization, applicationId, ownerId, payerCuit, screenTemplateName, securityContext);
    }

    @POST
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/document-set/payment-link")
    @Consumes({"application/json"})
    @Produces("application/json; charset=utf-8")
    public Response postDocumentSetPaymentLink(@HeaderParam("Authorization") String authorization, @PathParam("aid") String applicationId, @PathParam("ownerId") String ownerId, GicDocumentSet documentSet, @Context SecurityContext securityContext) {
        return paymentApiService.postDocumentSetPaymentLink(authorization, applicationId, ownerId, documentSet, securityContext);
    }

    @DELETE
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/document-set/payment-link")
    @Consumes({"application/json"})
    @Produces("application/json; charset=utf-8")
    public Response deleteDocumentSetPaymentLink(@HeaderParam("Authorization") String authorization, @PathParam("aid") String applicationId, @PathParam("ownerId") String ownerId, GicDocumentSet documentSet, @Context SecurityContext securityContext) {
        return paymentApiService.deleteDocumentSetPaymentLink(authorization, applicationId, ownerId, documentSet, securityContext);
    }

    @GET
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/payments")
    @Produces("application/json; charset=utf-8")
    public Response getPayments(@HeaderParam("Authorization") String authorization, @PathParam("aid") String applicationId, @PathParam("ownerId") String ownerId,
                                @QueryParam("fromCreationDate") String fromCreationDate,
                                @QueryParam("toCreationDate") String toCreationDate,
                                @QueryParam("ownerDocRefList") String ownerDocRefList,
                                @QueryParam("legalDocRefList") String legalDocRefList,
                                @Context SecurityContext securityContext) {
        return paymentApiService.getPayments(authorization, applicationId, ownerId, fromCreationDate, toCreationDate, ownerDocRefList, legalDocRefList, securityContext);
    }

    @GET
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/payment-status-info/orderNumber/{orderNumber}")
    @Produces("application/json; charset=utf-8")
    public Response getPaymentStatusInfo(@HeaderParam("Authorization") String authorization, @PathParam("aid") String applicationId, @PathParam("ownerId") String ownerId,
                               @PathParam("orderNumber") String orderNumber,
                               @Context SecurityContext securityContext) {
        return paymentApiService.getPaymentStatusInfo(authorization, applicationId, ownerId, orderNumber, securityContext);
    }

}
