/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.gicapi.api.payment;

import ar.com.sdd.commons.rest.log.ServerFileLogged;
import ar.com.sdd.commons.rest.model.ErrorResult;
import ar.com.sdd.ebfapi.client.model.ActionLink;
import ar.com.sdd.gicapi.api.payment.GicPaymentApiService;
import ar.com.sdd.gicapi.client.model.GicDocumentSet;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path(value="/gic-api/v1_0/payment")
public class GicPaymentApiEndpoint {
    @Inject
    private GicPaymentApiService paymentApiService;

    @GET
    @ServerFileLogged
    @Path(value="/aid/{aid}/owner/{ownerId}/payerCuit/{payerCuit}/payment-methods")
    @Produces(value={"application/json; charset=utf-8"})
    @Operation(summary="Consulta de medios de pagos disponibles a un cliente")
    public Response getPaymentMethods(@HeaderParam(value="Authorization") String authorization, @PathParam(value="aid") String applicationId, @PathParam(value="ownerId") String ownerId, @PathParam(value="payerCuit") String payerCuit, @Context SecurityContext securityContext) {
        return this.paymentApiService.getPaymentMethods(authorization, applicationId, ownerId, payerCuit, securityContext);
    }

    @GET
    @ServerFileLogged
    @Path(value="/aid/{aid}/owner/{ownerId}/payerCuit/{payerCuit}/document-set/{screenTemplateName}")
    @Produces(value={"application/json; charset=utf-8"})
    public Response getDocumentsSet(@HeaderParam(value="Authorization") String authorization, @PathParam(value="aid") String applicationId, @PathParam(value="ownerId") String ownerId, @PathParam(value="payerCuit") String payerCuit, @PathParam(value="screenTemplateName") String screenTemplateName, @Context SecurityContext securityContext) {
        return this.paymentApiService.getDocumentsSet(authorization, applicationId, ownerId, payerCuit, screenTemplateName, securityContext);
    }

    @POST
    @Operation(operationId="postDocumentSetPaymentLink", tags={"payment"}, summary="Creates payment for a set of document and provides a SSO link to it", responses={@ApiResponse(responseCode="200", description="Success", content={@Content(schema=@Schema(implementation=ActionLink.class))}), @ApiResponse(responseCode="400", description="General error", content={@Content(schema=@Schema(implementation=ErrorResult.class))}), @ApiResponse(responseCode="417", description="Wrong applicationId", content={@Content(schema=@Schema(implementation=ErrorResult.class))}), @ApiResponse(responseCode="418", description="Wrong owner", content={@Content(schema=@Schema(implementation=ErrorResult.class))}), @ApiResponse(responseCode="419", description="Invalid PaymentMethod", content={@Content(schema=@Schema(implementation=ErrorResult.class))})})
    @ServerFileLogged
    @Path(value="/aid/{aid}/owner/{ownerId}/document-set/payment-link")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response postDocumentSetPaymentLink(@Parameter(description="Bearer token generated in oAuth2 operation", required=true) @HeaderParam(value="Authorization") String authorization, @Parameter(description="ApplicationId, unique identifier of the application. Value: GIC_EBFAPI", required=true, content={@Content(schema=@Schema(maxLength=50))}) @PathParam(value="aid") String applicationId, @Parameter(description="Company's CUIT", required=true) @Schema(maxLength=255) @PathParam(value="ownerId") String ownerId, @RequestBody(description="Set of documents to create", required=true, content={@Content(schema=@Schema(implementation=GicDocumentSet.class))}) GicDocumentSet documentSet, @Context SecurityContext securityContext) {
        return this.paymentApiService.postDocumentSetPaymentLink(authorization, applicationId, ownerId, documentSet, securityContext);
    }

    @DELETE
    @ServerFileLogged
    @Path(value="/aid/{aid}/owner/{ownerId}/document-set/payment-link")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json; charset=utf-8"})
    public Response deleteDocumentSetPaymentLink(@HeaderParam(value="Authorization") String authorization, @PathParam(value="aid") String applicationId, @PathParam(value="ownerId") String ownerId, GicDocumentSet documentSet, @Context SecurityContext securityContext) {
        return this.paymentApiService.deleteDocumentSetPaymentLink(authorization, applicationId, ownerId, documentSet, securityContext);
    }

    @GET
    @ServerFileLogged
    @Path(value="/aid/{aid}/owner/{ownerId}/payments")
    @Produces(value={"application/json; charset=utf-8"})
    public Response getPayments(@HeaderParam(value="Authorization") String authorization, @PathParam(value="aid") String applicationId, @PathParam(value="ownerId") String ownerId, @QueryParam(value="fromCreationDate") String fromCreationDate, @QueryParam(value="toCreationDate") String toCreationDate, @QueryParam(value="ownerDocRefList") String ownerDocRefList, @QueryParam(value="legalDocRefList") String legalDocRefList, @QueryParam(value="offset") Integer offset, @QueryParam(value="limit") Integer limit, @Context SecurityContext securityContext) {
        return this.paymentApiService.getPayments(authorization, applicationId, ownerId, fromCreationDate, toCreationDate, ownerDocRefList, legalDocRefList, offset, limit, securityContext);
    }

    @GET
    @ServerFileLogged
    @Path(value="/aid/{aid}/owner/{ownerId}/payment-status-info/orderNumber/{orderNumber}")
    @Produces(value={"application/json; charset=utf-8"})
    public Response getPaymentStatusInfo(@HeaderParam(value="Authorization") String authorization, @PathParam(value="aid") String applicationId, @PathParam(value="ownerId") String ownerId, @PathParam(value="orderNumber") String orderNumber, @Context SecurityContext securityContext) {
        return this.paymentApiService.getPaymentStatusInfo(authorization, applicationId, ownerId, orderNumber, securityContext);
    }
}

