package ar.com.sdd.gicapi.api.payment;

import ar.com.sdd.gicapi.client.model.*;

import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

public interface GicPaymentApiService {

    /**
     * Consulta de medios de pagos disponibles para un  payer
     *
     * @return Collection&lt;{@link GicPaymentMethod}&gt;
     */
    Response getPaymentMethods(String authorization, String applicationId, String ownerId, String payerCuit, SecurityContext securityContext);

    /**
     * Consulta un screen especifico para obtener deuda
     *
     * @return {@link GicDocumentSet}
     */
    Response getDocumentsSet(String authorization, String applicationId, String ownerId, String payerCuit, String screenTemplateName, SecurityContext securityContext);

    /**
     * Arma una orden de pago a partir de los documentos pasados dentro del {@link GicDocumentSet#getDocuments()} y devuelve un link hacia la OP creada.
     * Si ya existe la OP, devuelve el link hacia la misma
     * Tambi&eacute; permite la edici&oacute;n de los medios de pago de dicha OP (ya sea que la este creando o si ya estaba creada)
     *
     * @return {@link GicPaymentLink}
     */
    Response postDocumentSetPaymentLink(String authorization, String applicationId, String ownerId, GicDocumentSet documentSet, SecurityContext securityContext);

    /**
     * Elimina un DPG via evento PAN. El DPG lo encuentra por ownerDocRef a partir de la referencia que viene en el gicDocumentSet.trackingNumber
     *
     * @return status 200
     */
    Response deleteDocumentSetPaymentLink(String authorization, String applicationId, String ownerId, GicDocumentSet documentSet, SecurityContext securityContext);

    /**
     * Busca pagos de un por rango de fechas o referencias
     *
     * @return Collection&lt;{@link GicPayment}&gt;
     */
    Response getPayments(String authorization, String applicationId, String ownerId, String fromCreationDate, String toCreationDate, String ownerDocRefList, String legalDocRefList, Integer offset, Integer limit, SecurityContext securityContext);

    /**
     * Consulta status mas conciso de un orderNumber: status, fecha, xx
     *
     * @return {@link GicPaymentStatusInfo}
     */
    Response getPaymentStatusInfo(String authorization, String applicationId, String ownerId, String orderNumber, SecurityContext securityContext);

    /**
     * Crea un orden de pago del tipo MP.RET y le agrega la retencion informada en el request body junto con el adjunto
     *
     * @return {@link String}
     */
    Response postWithholding(String authorization, String applicationId, String ownerId, GicDocument withholding, SecurityContext securityContext);

    /**
     * Consulta de retenciones disponibles
     *
     * @return Collection&lt;{@link GicWithholdingCode}&gt;
     */
    Response getWithholdingCodes(String authorization, String applicationId, String ownerId, SecurityContext securityContext);
}