package ar.com.sdd.hlcmapi.io;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class InvoicesRequest implements Serializable {

    @JsonProperty("company_code")
    private String companyCode;

    @JsonProperty("payer_code")
    private String payerCode;

    @JsonProperty("state_interfaz")
    private String stateInterfaz;

    @JsonProperty("sec_transmition")
    private String secTransmition;

    public InvoicesRequest(String companyCode, String payerCode) {
        this.companyCode = companyCode;
        this.payerCode = payerCode;
    }

    public String getCompanyCode() {
        return companyCode;
    }

    public void setCompanyCode(String companyCode) {
        this.companyCode = companyCode;
    }

    public String getPayerCode() {
        return payerCode;
    }

    public void setPayerCode(String payerCode) {
        this.payerCode = payerCode;
    }

    public String getStateInterfaz() {
        return stateInterfaz;
    }

    public void setStateInterfaz(String stateInterfaz) {
        this.stateInterfaz = stateInterfaz;
    }

    public String getSecTransmition() {
        return secTransmition;
    }

    public void setSecTransmition(String secTransmition) {
        this.secTransmition = secTransmition;
    }

    @Override
    public String toString() {
        return "InvoicesRequest [" +
                ((companyCode != null) ? "companyCode='" + companyCode + "', " : "") +
                ((payerCode != null) ? "payerCode='" + payerCode + "', " : "") +
                ((stateInterfaz != null) ? "stateInterfaz='" + stateInterfaz + "', " : "") +
                ((secTransmition != null) ? "secTransmition='" + secTransmition + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        InvoicesRequest that = (InvoicesRequest) o;
        return Objects.equals(companyCode, that.companyCode) && Objects.equals(payerCode, that.payerCode) && Objects.equals(stateInterfaz, that.stateInterfaz) && Objects.equals(secTransmition, that.secTransmition);
    }

    @Override
    public int hashCode() {
        return Objects.hash(companyCode, payerCode, stateInterfaz, secTransmition);
    }
}