package ar.com.sdd.hlcmapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Document implements Serializable {

    @JsonProperty("sec_transmition")
    private String secTransmition;

    @JsonProperty("import")
    private String importe;

    @JsonProperty("type_doc")
    private String typeDoc;

    @JsonProperty("description")
    private String description;

    @JsonProperty("posting_key")
    private String postingKey;

    @JsonProperty("total_import")
    private String totalImport;

    @JsonProperty("currency_code")
    private String currencyCode;

    @JsonProperty("payer_code")
    private String payerCode;

    @JsonProperty("exp_days")
    private String expDays;

    @JsonProperty("num_document")
    private String numDocument;

    @JsonProperty("doc_date")
    private String docDate;

    @JsonProperty("folio")
    private String folio;

    @JsonProperty("text_exp")
    private String textExp;

    @JsonProperty("local_import")
    private String localImport;

    @JsonProperty("company_code")
    private String companyCode;

    @JsonProperty("exp_date")
    private String expDate;

    @JsonProperty("invoice")
    private String invoice;

    @JsonProperty("apunte_contable")
    private String apunteContable;

    @JsonProperty("year_document")
    private String yearDocument;

    @JsonProperty("doc_ventas")
    private String docVentas;

    @JsonProperty("api_update")
    private String apiUpdate;

    @JsonProperty("message")
    private String message;

    @JsonProperty("id_cme")
    private String idCme;

    @JsonProperty("check_number")
    private String checkNumber;

    @JsonProperty("due_date")
    private String dueDate;

    @JsonProperty("bank_Key")
    private String bankKey;

    @JsonProperty("bank_name")
    private String bankName;

    public String getImporte() {
        return importe;
    }

    public void setImporte(String importe) {
        this.importe = importe;
    }

    public String getTypeDoc() {
        return typeDoc;
    }

    public void setTypeDoc(String typeDoc) {
        this.typeDoc = typeDoc;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getPostingKey() {
        return postingKey;
    }

    public void setPostingKey(String postingKey) {
        this.postingKey = postingKey;
    }

    public String getTotalImport() {
        return totalImport;
    }

    public void setTotalImport(String totalImport) {
        this.totalImport = totalImport;
    }

    public String getCurrencyCode() {
        return currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public String getPayerCode() {
        return payerCode;
    }

    public void setPayerCode(String payerCode) {
        this.payerCode = payerCode;
    }

    public String getExpDays() {
        return expDays;
    }

    public void setExpDays(String expDays) {
        this.expDays = expDays;
    }

    public String getNumDocument() {
        return numDocument;
    }

    public void setNumDocument(String numDocument) {
        this.numDocument = numDocument;
    }

    public String getDocDate() {
        return docDate;
    }

    public void setDocDate(String docDate) {
        this.docDate = docDate;
    }

    public String getFolio() {
        return folio;
    }

    public void setFolio(String folio) {
        this.folio = folio;
    }

    public String getTextExp() {
        return textExp;
    }

    public void setTextExp(String textExp) {
        this.textExp = textExp;
    }

    public String getLocalImport() {
        return localImport;
    }

    public void setLocalImport(String localImport) {
        this.localImport = localImport;
    }

    public String getCompanyCode() {
        return companyCode;
    }

    public void setCompanyCode(String companyCode) {
        this.companyCode = companyCode;
    }

    public String getExpDate() {
        return expDate;
    }

    public void setExpDate(String expDate) {
        this.expDate = expDate;
    }

    public String getInvoice() {
        return invoice;
    }

    public void setInvoice(String invoice) {
        this.invoice = invoice;
    }

    public String getApunteContable() {
        return apunteContable;
    }

    public void setApunteContable(String apunteContable) {
        this.apunteContable = apunteContable;
    }

    public String getYearDocument() {
        return yearDocument;
    }

    public void setYearDocument(String yearDocument) {
        this.yearDocument = yearDocument;
    }

    @Override
    public String toString() {
        return "Document [" +
                ((importe != null) ? "importe='" + importe + "', " : "") +
                ((typeDoc != null) ? "typeDoc='" + typeDoc + "', " : "") +
                ((description != null) ? "description='" + description + "', " : "") +
                ((postingKey != null) ? "postingKey='" + postingKey + "', " : "") +
                ((totalImport != null) ? "totalImport='" + totalImport + "', " : "") +
                ((currencyCode != null) ? "currencyCode='" + currencyCode + "', " : "") +
                ((payerCode != null) ? "payerCode='" + payerCode + "', " : "") +
                ((expDays != null) ? "expDays='" + expDays + "', " : "") +
                ((numDocument != null) ? "numDocument='" + numDocument + "', " : "") +
                ((docDate != null) ? "docDate='" + docDate + "', " : "") +
                ((folio != null) ? "folio='" + folio + "', " : "") +
                ((textExp != null) ? "textExp='" + textExp + "', " : "") +
                ((localImport != null) ? "localImport='" + localImport + "', " : "") +
                ((companyCode != null) ? "companyCode='" + companyCode + "', " : "") +
                ((expDate != null) ? "expDate='" + expDate + "', " : "") +
                ((invoice != null) ? "invoice='" + invoice + "', " : "") +
                ((apunteContable != null) ? "apunteContable='" + apunteContable + "', " : "") +
                ((yearDocument != null) ? "yearDocument='" + yearDocument + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Document document = (Document) o;
        return Objects.equals(importe, document.importe) && Objects.equals(typeDoc, document.typeDoc) && Objects.equals(description, document.description) && Objects.equals(postingKey, document.postingKey) && Objects.equals(totalImport, document.totalImport) && Objects.equals(currencyCode, document.currencyCode) && Objects.equals(payerCode, document.payerCode) && Objects.equals(expDays, document.expDays) && Objects.equals(numDocument, document.numDocument) && Objects.equals(docDate, document.docDate) && Objects.equals(folio, document.folio) && Objects.equals(textExp, document.textExp) && Objects.equals(localImport, document.localImport) && Objects.equals(companyCode, document.companyCode) && Objects.equals(expDate, document.expDate) && Objects.equals(invoice, document.invoice) && Objects.equals(apunteContable, document.apunteContable) && Objects.equals(yearDocument, document.yearDocument);
    }

    @Override
    public int hashCode() {
        return Objects.hash(importe, typeDoc, description, postingKey, totalImport, currencyCode, payerCode, expDays, numDocument, docDate, folio, textExp, localImport, companyCode, expDate, invoice, apunteContable, yearDocument);
    }
}