package ar.com.sdd.hlcmapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Payment implements Serializable {


    @JsonProperty("m_client")
    private String mClient;

    @JsonProperty("sec_transmition")
    private String secTransmition;

    @JsonProperty("payer_code")
    private String payerCode;

    @JsonProperty("id_client")
    private String idClient;

    @JsonProperty("level_client")
    private String levelClient;

    @JsonProperty("type_service")
    private String typeService;

    @JsonProperty("import")
    private BigDecimal importe;

    @JsonProperty("description")
    private String description;

    @JsonProperty("currency_code")
    private String currencyCode;

    @JsonProperty("language")
    private String language;

    @JsonProperty("finance")
    private String finance;

    @JsonProperty("profile_finan")
    private String profileFinan;

    @JsonProperty("email")
    private String email;

    @JsonProperty("telephone")
    private String telephone;

    @JsonProperty("exp_date")
    private String expDate;

    @JsonProperty("payment_method")
    private String paymentMethod;

    @JsonProperty("code_approval")
    private String codeApproval;

    @JsonProperty("folio_mp")
    private String folioMp;

    @JsonProperty("hour")
    private String hour;

    @JsonProperty("hour_date")
    private String hourDate;

    @JsonProperty("state_interfaz")
    private String stateInterfaz;

    @JsonProperty("error_descrip")
    private String errorDescrip;

    @JsonProperty("company_code")
    private String companyCode;

    @JsonProperty("year_comp ")
    private String yearComp;

    @JsonProperty("mod_data")
    private String modData;

    @JsonProperty("hour_mod")
    private String hourMod;

    @JsonProperty("user_mod")
    private String userMod;

    @JsonProperty("eraser")
    private String eraser;

    @JsonProperty("crea_data")
    private String creaData;

    @JsonProperty("hour_crea")
    private String hourCrea;

    @JsonProperty("user_crea")
    private String userCrea;

    @JsonProperty("indic_clear")
    private String indicClear;

    @JsonProperty("num_document")
    private String numDocument;

    @JsonProperty("year_document")
    private String yearDocument;

    @JsonProperty("pay_system")
    private String paySystem;

    @JsonProperty("nif")
    private String nif;

    @JsonProperty("invoice")
    private String invoice;

    @JsonProperty("discount")
    private String discount;

    @JsonProperty("business_area")
    private String businessArea;

    @JsonProperty("Payment_flow")
    private String paymentFlow;

    @JsonProperty("Region")
    private String region;

    public String getmClient() {
        return mClient;
    }

    public void setmClient(String mClient) {
        this.mClient = mClient;
    }

    public String getSecTransmition() {
        return secTransmition;
    }

    public void setSecTransmition(String secTransmition) {
        this.secTransmition = secTransmition;
    }

    public String getPayerCode() {
        return payerCode;
    }

    public void setPayerCode(String payerCode) {
        this.payerCode = payerCode;
    }

    public String getIdClient() {
        return idClient;
    }

    public void setIdClient(String idClient) {
        this.idClient = idClient;
    }

    public String getLevelClient() {
        return levelClient;
    }

    public void setLevelClient(String levelClient) {
        this.levelClient = levelClient;
    }

    public String getTypeService() {
        return typeService;
    }

    public void setTypeService(String typeService) {
        this.typeService = typeService;
    }

    public BigDecimal getImporte() {
        return importe;
    }

    public void setImporte(BigDecimal importe) {
        this.importe = importe;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCurrencyCode() {
        return currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public String getLanguage() {
        return language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getFinance() {
        return finance;
    }

    public void setFinance(String finance) {
        this.finance = finance;
    }

    public String getProfileFinan() {
        return profileFinan;
    }

    public void setProfileFinan(String profileFinan) {
        this.profileFinan = profileFinan;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getTelephone() {
        return telephone;
    }

    public void setTelephone(String telephone) {
        this.telephone = telephone;
    }

    public String getExpDate() {
        return expDate;
    }

    public void setExpDate(String expDate) {
        this.expDate = expDate;
    }

    public String getPaymentMethod() {
        return paymentMethod;
    }

    public void setPaymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public String getCodeApproval() {
        return codeApproval;
    }

    public void setCodeApproval(String codeApproval) {
        this.codeApproval = codeApproval;
    }

    public String getFolioMp() {
        return folioMp;
    }

    public void setFolioMp(String folioMp) {
        this.folioMp = folioMp;
    }

    public String getHour() {
        return hour;
    }

    public void setHour(String hour) {
        this.hour = hour;
    }

    public String getHourDate() {
        return hourDate;
    }

    public void setHourDate(String hourDate) {
        this.hourDate = hourDate;
    }

    public String getStateInterfaz() {
        return stateInterfaz;
    }

    public void setStateInterfaz(String stateInterfaz) {
        this.stateInterfaz = stateInterfaz;
    }

    public String getErrorDescrip() {
        return errorDescrip;
    }

    public void setErrorDescrip(String errorDescrip) {
        this.errorDescrip = errorDescrip;
    }

    public String getCompanyCode() {
        return companyCode;
    }

    public void setCompanyCode(String companyCode) {
        this.companyCode = companyCode;
    }

    public String getYearComp() {
        return yearComp;
    }

    public void setYearComp(String yearComp) {
        this.yearComp = yearComp;
    }

    public String getModData() {
        return modData;
    }

    public void setModData(String modData) {
        this.modData = modData;
    }

    public String getHourMod() {
        return hourMod;
    }

    public void setHourMod(String hourMod) {
        this.hourMod = hourMod;
    }

    public String getUserMod() {
        return userMod;
    }

    public void setUserMod(String userMod) {
        this.userMod = userMod;
    }

    public String getEraser() {
        return eraser;
    }

    public void setEraser(String eraser) {
        this.eraser = eraser;
    }

    public String getCreaData() {
        return creaData;
    }

    public void setCreaData(String creaData) {
        this.creaData = creaData;
    }

    public String getHourCrea() {
        return hourCrea;
    }

    public void setHourCrea(String hourCrea) {
        this.hourCrea = hourCrea;
    }

    public String getUserCrea() {
        return userCrea;
    }

    public void setUserCrea(String userCrea) {
        this.userCrea = userCrea;
    }

    public String getIndicClear() {
        return indicClear;
    }

    public void setIndicClear(String indicClear) {
        this.indicClear = indicClear;
    }

    public String getNumDocument() {
        return numDocument;
    }

    public void setNumDocument(String numDocument) {
        this.numDocument = numDocument;
    }

    public String getYearDocument() {
        return yearDocument;
    }

    public void setYearDocument(String yearDocument) {
        this.yearDocument = yearDocument;
    }

    public String getPaySystem() {
        return paySystem;
    }

    public void setPaySystem(String paySystem) {
        this.paySystem = paySystem;
    }

    public String getNif() {
        return nif;
    }

    public void setNif(String nif) {
        this.nif = nif;
    }

    public String getInvoice() {
        return invoice;
    }

    public void setInvoice(String invoice) {
        this.invoice = invoice;
    }

    public String getDiscount() {
        return discount;
    }

    public void setDiscount(String discount) {
        this.discount = discount;
    }

    public String getBusinessArea() {
        return businessArea;
    }

    public void setBusinessArea(String businessArea) {
        this.businessArea = businessArea;
    }

    public String getPaymentFlow() {
        return paymentFlow;
    }

    public void setPaymentFlow(String paymentFlow) {
        this.paymentFlow = paymentFlow;
    }

    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    @Override
    public String toString() {
        return "Payment [" +
                ((mClient != null) ? "mClient='" + mClient + "', " : "") +
                ((secTransmition != null) ? "secTransmition='" + secTransmition + "', " : "") +
                ((payerCode != null) ? "payerCode='" + payerCode + "', " : "") +
                ((idClient != null) ? "idClient='" + idClient + "', " : "") +
                ((levelClient != null) ? "levelClient='" + levelClient + "', " : "") +
                ((typeService != null) ? "typeService='" + typeService + "', " : "") +
                ((importe != null) ? "importe=" + importe + ", " : "") +
                ((description != null) ? "description='" + description + "', " : "") +
                ((currencyCode != null) ? "currencyCode='" + currencyCode + "', " : "") +
                ((language != null) ? "language='" + language + "', " : "") +
                ((finance != null) ? "finance='" + finance + "', " : "") +
                ((profileFinan != null) ? "profileFinan='" + profileFinan + "', " : "") +
                ((email != null) ? "email='" + email + "', " : "") +
                ((telephone != null) ? "telephone='" + telephone + "', " : "") +
                ((expDate != null) ? "expDate='" + expDate + "', " : "") +
                ((paymentMethod != null) ? "paymentMethod='" + paymentMethod + "', " : "") +
                ((codeApproval != null) ? "codeApproval='" + codeApproval + "', " : "") +
                ((folioMp != null) ? "folioMp='" + folioMp + "', " : "") +
                ((hour != null) ? "hour='" + hour + "', " : "") +
                ((hourDate != null) ? "hourDate='" + hourDate + "', " : "") +
                ((stateInterfaz != null) ? "stateInterfaz='" + stateInterfaz + "', " : "") +
                ((errorDescrip != null) ? "errorDescrip='" + errorDescrip + "', " : "") +
                ((companyCode != null) ? "companyCode='" + companyCode + "', " : "") +
                ((yearComp != null) ? "yearComp='" + yearComp + "', " : "") +
                ((modData != null) ? "modData='" + modData + "', " : "") +
                ((hourMod != null) ? "hourMod='" + hourMod + "', " : "") +
                ((userMod != null) ? "userMod='" + userMod + "', " : "") +
                ((eraser != null) ? "eraser='" + eraser + "', " : "") +
                ((creaData != null) ? "creaData='" + creaData + "', " : "") +
                ((hourCrea != null) ? "hourCrea='" + hourCrea + "', " : "") +
                ((userCrea != null) ? "userCrea='" + userCrea + "', " : "") +
                ((indicClear != null) ? "indicClear='" + indicClear + "', " : "") +
                ((numDocument != null) ? "numDocument='" + numDocument + "', " : "") +
                ((yearDocument != null) ? "yearDocument='" + yearDocument + "', " : "") +
                ((paySystem != null) ? "paySystem='" + paySystem + "', " : "") +
                ((nif != null) ? "nif='" + nif + "', " : "") +
                ((invoice != null) ? "invoice='" + invoice + "', " : "") +
                ((discount != null) ? "discount='" + discount + "', " : "") +
                ((businessArea != null) ? "businessArea='" + businessArea + "', " : "") +
                ((paymentFlow != null) ? "paymentFlow='" + paymentFlow + "', " : "") +
                ((region != null) ? "region='" + region + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Payment payment = (Payment) o;
        return Objects.equals(mClient, payment.mClient) && Objects.equals(secTransmition, payment.secTransmition) && Objects.equals(payerCode, payment.payerCode) && Objects.equals(idClient, payment.idClient) && Objects.equals(levelClient, payment.levelClient) && Objects.equals(typeService, payment.typeService) && Objects.equals(importe, payment.importe) && Objects.equals(description, payment.description) && Objects.equals(currencyCode, payment.currencyCode) && Objects.equals(language, payment.language) && Objects.equals(finance, payment.finance) && Objects.equals(profileFinan, payment.profileFinan) && Objects.equals(email, payment.email) && Objects.equals(telephone, payment.telephone) && Objects.equals(expDate, payment.expDate) && Objects.equals(paymentMethod, payment.paymentMethod) && Objects.equals(codeApproval, payment.codeApproval) && Objects.equals(folioMp, payment.folioMp) && Objects.equals(hour, payment.hour) && Objects.equals(hourDate, payment.hourDate) && Objects.equals(stateInterfaz, payment.stateInterfaz) && Objects.equals(errorDescrip, payment.errorDescrip) && Objects.equals(companyCode, payment.companyCode) && Objects.equals(yearComp, payment.yearComp) && Objects.equals(modData, payment.modData) && Objects.equals(hourMod, payment.hourMod) && Objects.equals(userMod, payment.userMod) && Objects.equals(eraser, payment.eraser) && Objects.equals(creaData, payment.creaData) && Objects.equals(hourCrea, payment.hourCrea) && Objects.equals(userCrea, payment.userCrea) && Objects.equals(indicClear, payment.indicClear) && Objects.equals(numDocument, payment.numDocument) && Objects.equals(yearDocument, payment.yearDocument) && Objects.equals(paySystem, payment.paySystem) && Objects.equals(nif, payment.nif) && Objects.equals(invoice, payment.invoice) && Objects.equals(discount, payment.discount) && Objects.equals(businessArea, payment.businessArea) && Objects.equals(paymentFlow, payment.paymentFlow) && Objects.equals(region, payment.region);
    }

    @Override
    public int hashCode() {
        return Objects.hash(mClient, secTransmition, payerCode, idClient, levelClient, typeService, importe, description, currencyCode, language, finance, profileFinan, email, telephone, expDate, paymentMethod, codeApproval, folioMp, hour, hourDate, stateInterfaz, errorDescrip, companyCode, yearComp, modData, hourMod, userMod, eraser, creaData, hourCrea, userCrea, indicClear, numDocument, yearDocument, paySystem, nif, invoice, discount, businessArea, paymentFlow, region);
    }
}