package ar.com.sdd.hlcmapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Return implements Serializable {

    @JsonProperty("type_message")
    private String type;

    @JsonProperty("text_message")
    private String text;

    @JsonProperty("id_message")
    private String id;

    @JsonProperty("row")
    private String row;

    @JsonProperty("num_message")
    private String num;

    @JsonProperty("message1")
    private String message1;

    @JsonProperty("message2")
    private String message2;

    @JsonProperty("message3")
    private Integer message3;

    @JsonProperty("message4")
    private Integer message4;

    @JsonProperty("log_msg_no")
    private String logMsgNo;

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getText() {
        return text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRow() {
        return row;
    }

    public void setRow(String row) {
        this.row = row;
    }

    public String getNum() {
        return num;
    }

    public void setNum(String num) {
        this.num = num;
    }

    public String getMessage1() {
        return message1;
    }

    public void setMessage1(String message1) {
        this.message1 = message1;
    }

    public String getMessage2() {
        return message2;
    }

    public void setMessage2(String message2) {
        this.message2 = message2;
    }

    public Integer getMessage3() {
        return message3;
    }

    public void setMessage3(Integer message3) {
        this.message3 = message3;
    }

    public Integer getMessage4() {
        return message4;
    }

    public void setMessage4(Integer message4) {
        this.message4 = message4;
    }

    public String getLogMsgNo() {
        return logMsgNo;
    }

    public void setLogMsgNo(String logMsgNo) {
        this.logMsgNo = logMsgNo;
    }

    @Override
    public String toString() {
        return "Return [" +
                ((type != null) ? "type='" + type + "', " : "") +
                ((text != null) ? "text='" + text + "', " : "") +
                ((id != null) ? "id='" + id + "', " : "") +
                ((row != null) ? "row='" + row + "', " : "") +
                ((num != null) ? "num='" + num + "', " : "") +
                ((message1 != null) ? "message1='" + message1 + "', " : "") +
                ((message2 != null) ? "message2='" + message2 + "', " : "") +
                ((message3 != null) ? "message3=" + message3 + ", " : "") +
                ((message4 != null) ? "message4=" + message4 + ", " : "") +
                ((logMsgNo != null) ? "logMsgNo='" + logMsgNo + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Return aReturn = (Return) o;
        return Objects.equals(type, aReturn.type) && Objects.equals(text, aReturn.text) && Objects.equals(id, aReturn.id) && Objects.equals(row, aReturn.row) && Objects.equals(num, aReturn.num) && Objects.equals(message1, aReturn.message1) && Objects.equals(message2, aReturn.message2) && Objects.equals(message3, aReturn.message3) && Objects.equals(message4, aReturn.message4) && Objects.equals(logMsgNo, aReturn.logMsgNo);
    }

    @Override
    public int hashCode() {
        return Objects.hash(type, text, id, row, num, message1, message2, message3, message4, logMsgNo);
    }
}