package ar.com.sdd.hlcmapi.model;

import ar.com.sdd.commons.util.StringUtil;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@SuppressWarnings("unused")
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Payment implements Serializable {

    @JsonProperty("m_client")
    private String mClient;

    @JsonProperty("sec_transmition")
    private String secTransmition;

    @JsonProperty("payer_code")
    private String payerCode;

    @JsonProperty("id_client")
    private String idClient;

    @JsonProperty("level_client")
    private String levelClient;

    @JsonProperty("type_service")
    private String typeService;

    @JsonProperty("import")
    private String importe;

    @JsonProperty("description")
    private String description;

    @JsonProperty("currency_code")
    private String currencyCode;

    @JsonProperty("language")
    private String language;

    @JsonProperty("finance")
    private String finance;

    @JsonProperty("profile_finan")
    private String profileFinan;

    @JsonProperty("email")
    private String email;

    @JsonProperty("telephone")
    private String telephone;

    @JsonProperty("exp_date")
    private String expDate;

    @JsonProperty("payment_method")
    private String paymentMethod;

    @JsonProperty("code_approval")
    private String codeApproval;

    @JsonProperty("folio_mp")
    private String folioMp;

    @JsonProperty("hour")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss.SSSSSS", timezone = "GMT-03:00")
    private Date hour;

    @JsonProperty("hour_date")
    private String hourDate;

    @JsonProperty("state_interfaz")
    private String stateInterfaz;

    @JsonProperty("error_descrip")
    private String errorDescrip;

    @JsonProperty("company_code")
    private String companyCode;

    @JsonProperty("comp_document")
    private String compDocument;

    @JsonProperty("year_comp")
    private String yearComp;

    @JsonProperty("mod_data")
    private String modData;

    @JsonProperty("hour_mod")
    private String hourMod;

    @JsonProperty("user_mod")
    private String userMod;

    @JsonProperty("eraser")
    private String eraser;

    @JsonProperty("crea_data")
    private String creaData;

    @JsonProperty("hour_crea")
    private String hourCrea;

    @JsonProperty("user_crea")
    private String userCrea;

    @JsonProperty("indic_clear")
    private String indicClear;

    @JsonProperty("num_document")
    private String numDocument;

    @JsonProperty("year_document")
    private String yearDocument;

    @JsonProperty("pay_system")
    private String paySystem;

    @JsonProperty("conveniocie")
    private String convenioCie;

    @JsonProperty("nif")
    private String nif;

    @JsonProperty("invoice")
    private String invoice;

    @JsonProperty("discount")
    private String discount;

    @JsonProperty("business_area")
    private String businessArea;

    @JsonProperty("Payment_flow")
    private String paymentFlow;

    @JsonProperty("Region")
    private String region;

    public String getmClient() {
        return mClient;
    }

    public void setmClient(String mClient) {
        this.mClient = StringUtil.trunc(mClient, 3);
    }

    public String getSecTransmition() {
        return secTransmition;
    }

    public void setSecTransmition(String secTransmition) {
        this.secTransmition = StringUtil.trunc(secTransmition, 16);
    }

    public String getPayerCode() {
        return payerCode;
    }

    public void setPayerCode(String payerCode) {
        this.payerCode = StringUtil.trunc(payerCode, 20);
    }

    public String getIdClient() {
        return idClient;
    }

    public void setIdClient(String idClient) {
        this.idClient = StringUtil.trunc(idClient, 5);
    }

    public String getLevelClient() {
        return levelClient;
    }

    public void setLevelClient(String levelClient) {
        this.levelClient = StringUtil.trunc(levelClient, 5);
    }

    public String getTypeService() {
        return typeService;
    }

    public void setTypeService(String typeService) {
        this.typeService = StringUtil.trunc(typeService, 35);
    }

    public String getImporte() {
        return importe;
    }

    public void setImporte(String importe) {
        this.importe = StringUtil.trunc(importe, 9);
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = StringUtil.trunc(description, 50);
    }

    public String getCurrencyCode() {
        return currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = StringUtil.trunc(currencyCode, 3);
    }

    public String getLanguage() {
        return language;
    }

    public void setLanguage(String language) {
        this.language = StringUtil.trunc(language, 1);
    }

    public String getFinance() {
        return finance;
    }

    public void setFinance(String finance) {
        this.finance = StringUtil.trunc(finance, 1);
    }

    public String getProfileFinan() {
        return profileFinan;
    }

    public void setProfileFinan(String profileFinan) {
        this.profileFinan = StringUtil.trunc(profileFinan, 100);
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = StringUtil.trunc(email, 50);
    }

    public String getTelephone() {
        return telephone;
    }

    public void setTelephone(String telephone) {
        this.telephone = StringUtil.trunc(telephone, 30);
    }

    public String getExpDate() {
        return expDate;
    }

    public void setExpDate(String expDate) {
        this.expDate = StringUtil.trunc(expDate, 10);
    }

    public String getPaymentMethod() {
        return paymentMethod;
    }

    public void setPaymentMethod(String paymentMethod) {
        this.paymentMethod = StringUtil.trunc(paymentMethod, 2);
    }

    public String getCodeApproval() {
        return codeApproval;
    }

    public void setCodeApproval(String codeApproval) {
        this.codeApproval = StringUtil.trunc(codeApproval, 8);
    }

    public String getFolioMp() {
        return folioMp;
    }

    public void setFolioMp(String folioMp) {
        this.folioMp = StringUtil.trunc(folioMp, 50);
    }

    public Date getHour() {
        return hour;
    }

    public void setHour(Date hour) {
        this.hour = hour;
    }

    public String getHourDate() {
        return hourDate;
    }

    public void setHourDate(String hourDate) {
        this.hourDate = StringUtil.trunc(hourDate, 50);
    }

    public String getStateInterfaz() {
        return stateInterfaz;
    }

    public void setStateInterfaz(String stateInterfaz) {
        this.stateInterfaz = StringUtil.trunc(stateInterfaz, 2);
    }

    public String getErrorDescrip() {
        return errorDescrip;
    }

    public void setErrorDescrip(String errorDescrip) {
        this.errorDescrip = StringUtil.trunc(errorDescrip, 500);
    }

    public String getCompanyCode() {
        return companyCode;
    }

    public void setCompanyCode(String companyCode) {
        this.companyCode = StringUtil.trunc(companyCode, 4);
    }

    public String getCompDocument() {
        return compDocument;
    }

    public void setCompDocument(String compDocument) {
        this.compDocument = StringUtil.trunc(compDocument, 10);
    }

    public String getYearComp() {
        return yearComp;
    }

    public void setYearComp(String yearComp) {
        this.yearComp = StringUtil.trunc(yearComp, 4);
    }

    public String getModData() {
        return modData;
    }

    public void setModData(String modData) {
        this.modData = StringUtil.trunc(modData, 8);
    }

    public String getHourMod() {
        return hourMod;
    }

    public void setHourMod(String hourMod) {
        this.hourMod = StringUtil.trunc(hourMod, 6);
    }

    public String getUserMod() {
        return userMod;
    }

    public void setUserMod(String userMod) {
        this.userMod = StringUtil.trunc(userMod, 12);
    }

    public String getEraser() {
        return eraser;
    }

    public void setEraser(String eraser) {
        this.eraser = StringUtil.trunc(eraser, 1);
    }

    public String getCreaData() {
        return creaData;
    }

    public void setCreaData(String creaData) {
        this.creaData = StringUtil.trunc(creaData, 1);
    }

    public String getHourCrea() {
        return hourCrea;
    }

    public void setHourCrea(String hourCrea) {
        this.hourCrea = StringUtil.trunc(hourCrea, 6);
    }

    public String getUserCrea() {
        return userCrea;
    }

    public void setUserCrea(String userCrea) {
        this.userCrea = StringUtil.trunc(userCrea, 12);
    }

    public String getIndicClear() {
        return indicClear;
    }

    public void setIndicClear(String indicClear) {
        this.indicClear = StringUtil.trunc(indicClear, 1);
    }

    public String getNumDocument() {
        return numDocument;
    }

    public void setNumDocument(String numDocument) {
        this.numDocument = StringUtil.trunc(numDocument, 10);
    }

    public String getYearDocument() {
        return yearDocument;
    }

    public void setYearDocument(String yearDocument) {
        this.yearDocument = StringUtil.trunc(yearDocument, 4);
    }

    public String getPaySystem() {
        return paySystem;
    }

    public void setPaySystem(String paySystem) {
        this.paySystem = StringUtil.trunc(paySystem, 2);
    }

    public String getConvenioCie() {
        return convenioCie;
    }

    public void setConvenioCie(String convenioCie) {
        this.convenioCie = StringUtil.trunc(convenioCie, 7);
    }

    public String getNif() {
        return nif;
    }

    public void setNif(String nif) {
        this.nif = StringUtil.trunc(nif, 16);
    }

    public String getInvoice() {
        return invoice;
    }

    public void setInvoice(String invoice) {
        this.invoice = StringUtil.trunc(invoice, 10);
    }

    public String getDiscount() {
        return discount;
    }

    public void setDiscount(String discount) {
        this.discount = StringUtil.trunc(discount, 13);
    }

    public String getBusinessArea() {
        return businessArea;
    }

    public void setBusinessArea(String businessArea) {
        this.businessArea = StringUtil.trunc(businessArea, 4);
    }

    public String getPaymentFlow() {
        return paymentFlow;
    }

    public void setPaymentFlow(String paymentFlow) {
        this.paymentFlow = StringUtil.trunc(paymentFlow, 2);
    }

    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        this.region = StringUtil.trunc(region, 3);
    }

    @Override
    public String toString() {
        return "Payment [" +
                ((mClient != null) ? "mClient='" + mClient + "', " : "") +
                ((secTransmition != null) ? "secTransmition='" + secTransmition + "', " : "") +
                ((payerCode != null) ? "payerCode='" + payerCode + "', " : "") +
                ((idClient != null) ? "idClient='" + idClient + "', " : "") +
                ((levelClient != null) ? "levelClient='" + levelClient + "', " : "") +
                ((typeService != null) ? "typeService='" + typeService + "', " : "") +
                ((importe != null) ? "importe=" + importe + ", " : "") +
                ((description != null) ? "description='" + description + "', " : "") +
                ((currencyCode != null) ? "currencyCode='" + currencyCode + "', " : "") +
                ((language != null) ? "language='" + language + "', " : "") +
                ((finance != null) ? "finance='" + finance + "', " : "") +
                ((profileFinan != null) ? "profileFinan='" + profileFinan + "', " : "") +
                ((email != null) ? "email='" + email + "', " : "") +
                ((telephone != null) ? "telephone='" + telephone + "', " : "") +
                ((expDate != null) ? "expDate='" + expDate + "', " : "") +
                ((paymentMethod != null) ? "paymentMethod='" + paymentMethod + "', " : "") +
                ((codeApproval != null) ? "codeApproval='" + codeApproval + "', " : "") +
                ((folioMp != null) ? "folioMp='" + folioMp + "', " : "") +
                ((hour != null) ? "hour='" + hour + "', " : "") +
                ((hourDate != null) ? "hourDate='" + hourDate + "', " : "") +
                ((stateInterfaz != null) ? "stateInterfaz='" + stateInterfaz + "', " : "") +
                ((errorDescrip != null) ? "errorDescrip='" + errorDescrip + "', " : "") +
                ((companyCode != null) ? "companyCode='" + companyCode + "', " : "") +
                ((compDocument != null) ? "compDocument='" + compDocument + "', " : "") +
                ((yearComp != null) ? "yearComp='" + yearComp + "', " : "") +
                ((modData != null) ? "modData='" + modData + "', " : "") +
                ((hourMod != null) ? "hourMod='" + hourMod + "', " : "") +
                ((userMod != null) ? "userMod='" + userMod + "', " : "") +
                ((eraser != null) ? "eraser='" + eraser + "', " : "") +
                ((creaData != null) ? "creaData='" + creaData + "', " : "") +
                ((hourCrea != null) ? "hourCrea='" + hourCrea + "', " : "") +
                ((userCrea != null) ? "userCrea='" + userCrea + "', " : "") +
                ((indicClear != null) ? "indicClear='" + indicClear + "', " : "") +
                ((numDocument != null) ? "numDocument='" + numDocument + "', " : "") +
                ((yearDocument != null) ? "yearDocument='" + yearDocument + "', " : "") +
                ((paySystem != null) ? "paySystem='" + paySystem + "', " : "") +
                ((convenioCie != null) ? "convenioCie='" + convenioCie + "', " : "") +
                ((nif != null) ? "nif='" + nif + "', " : "") +
                ((invoice != null) ? "invoice='" + invoice + "', " : "") +
                ((discount != null) ? "discount='" + discount + "', " : "") +
                ((businessArea != null) ? "businessArea='" + businessArea + "', " : "") +
                ((paymentFlow != null) ? "paymentFlow='" + paymentFlow + "', " : "") +
                ((region != null) ? "region='" + region + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Payment payment = (Payment) o;
        return Objects.equals(mClient, payment.mClient) && Objects.equals(secTransmition, payment.secTransmition) && Objects.equals(payerCode, payment.payerCode) && Objects.equals(idClient, payment.idClient) && Objects.equals(levelClient, payment.levelClient) && Objects.equals(typeService, payment.typeService) && Objects.equals(importe, payment.importe) && Objects.equals(description, payment.description) && Objects.equals(currencyCode, payment.currencyCode) && Objects.equals(language, payment.language) && Objects.equals(finance, payment.finance) && Objects.equals(profileFinan, payment.profileFinan) && Objects.equals(email, payment.email) && Objects.equals(telephone, payment.telephone) && Objects.equals(expDate, payment.expDate) && Objects.equals(paymentMethod, payment.paymentMethod) && Objects.equals(codeApproval, payment.codeApproval) && Objects.equals(folioMp, payment.folioMp) && Objects.equals(hour, payment.hour) && Objects.equals(hourDate, payment.hourDate) && Objects.equals(stateInterfaz, payment.stateInterfaz) && Objects.equals(errorDescrip, payment.errorDescrip) && Objects.equals(companyCode, payment.companyCode) && Objects.equals(compDocument, payment.compDocument) && Objects.equals(yearComp, payment.yearComp) && Objects.equals(modData, payment.modData) && Objects.equals(hourMod, payment.hourMod) && Objects.equals(userMod, payment.userMod) && Objects.equals(eraser, payment.eraser) && Objects.equals(creaData, payment.creaData) && Objects.equals(hourCrea, payment.hourCrea) && Objects.equals(userCrea, payment.userCrea) && Objects.equals(indicClear, payment.indicClear) && Objects.equals(numDocument, payment.numDocument) && Objects.equals(yearDocument, payment.yearDocument) && Objects.equals(paySystem, payment.paySystem) && Objects.equals(convenioCie, payment.convenioCie) && Objects.equals(nif, payment.nif) && Objects.equals(invoice, payment.invoice) && Objects.equals(discount, payment.discount) && Objects.equals(businessArea, payment.businessArea) && Objects.equals(paymentFlow, payment.paymentFlow) && Objects.equals(region, payment.region);
    }

    @Override
    public int hashCode() {
        return Objects.hash(mClient, secTransmition, payerCode, idClient, levelClient, typeService, importe, description, currencyCode, language, finance, profileFinan, email, telephone, expDate, paymentMethod, codeApproval, folioMp, hour, hourDate, stateInterfaz, errorDescrip, companyCode, compDocument, yearComp, modData, hourMod, userMod, eraser, creaData, hourCrea, userCrea, indicClear, numDocument, yearDocument, paySystem, convenioCie, nif, invoice, discount, businessArea, paymentFlow, region);
    }
}