/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.hlcmapi.model;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

class CustomDateDeserializer
extends JsonDeserializer<Date> {
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");

    CustomDateDeserializer() {
    }

    public Date deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        String date = jsonParser.getText();
        try {
            return dateFormat.parse(date);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT-03:00"));
    }
}

