package ar.com.sdd.hlcmapi.model;

import ar.com.sdd.commons.util.StringUtil;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import javax.validation.constraints.Size;
import java.io.IOException;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import java.util.TimeZone;

@SuppressWarnings("unused")
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Document implements Serializable {

    @JsonProperty("sec_transmition")
    private String secTransmition;

    @JsonProperty("import")
    private String importe;

    @JsonProperty("type_doc")
    private String typeDoc;

    @JsonProperty("description")
    private String description;

    @JsonProperty("posting_key")
    private String postingKey;

    @JsonProperty("total_import")
    private String totalImport;

    @JsonProperty("currency_code")
    private String currencyCode;

    @JsonProperty("payer_code")
    private String payerCode;

    @JsonProperty("exp_days")
    private String expDays;

    @JsonProperty("num_document")
    private String numDocument;

    @JsonProperty("doc_date")
    @JsonSerialize(using = CustomDateSerializer.class)
    @JsonDeserialize(using = CustomDateDeserializer.class)
    private Date docDate;

    @JsonProperty("folio")
    private String folio;

    @JsonProperty("text_exp")
    private String textExp;

    @JsonProperty("local_import")
    private String localImport;

    @JsonProperty("company_code")
    private String companyCode;

    @JsonProperty("exp_date")
    @JsonSerialize(using = CustomDateSerializer.class)
    @JsonDeserialize(using = CustomDateDeserializer.class)
    private Date expDate;

    @JsonProperty("invoice")
    private String invoice;

    @JsonProperty("apunte_contable")
    private String apunteContable;

    @JsonProperty("year_document")
    private String yearDocument;

    @JsonProperty("doc_ventas")
    private String docVentas;

    @JsonProperty("api_update")
    private String apiUpdate;

    @JsonProperty("message")
    private String message;

    @JsonProperty("id_cme")
    private String idCme;

    @JsonProperty("check_number")
    private String checkNumber;

    @JsonProperty("due_date")
    @JsonSerialize(using = CustomDateSerializer.class)
    @JsonDeserialize(using = CustomDateDeserializer.class)
    private Date dueDate;

    @JsonProperty("bank_Key")
    private String bankKey;

    @JsonProperty("bank_name")
    private String bankName;

    @JsonProperty("reference")
    private String reference;

    public String getSecTransmition() {
        return secTransmition;
    }

    public void setSecTransmition(String secTransmition) {
        this.secTransmition = StringUtil.trunc(secTransmition, 16);
    }

    public String getImporte() {
        return importe;
    }

    public void setImporte(String importe) {
        this.importe = importe;
    }

    public String getTypeDoc() {
        return typeDoc;
    }

    public void setTypeDoc(String typeDoc) {
        this.typeDoc = StringUtil.trunc(typeDoc, 2);
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = StringUtil.trunc(description, 30);
    }

    public String getPostingKey() {
        return postingKey;
    }

    public void setPostingKey(String postingKey) {
        this.postingKey = StringUtil.trunc(postingKey, 2);
    }

    public String getTotalImport() {
        return totalImport;
    }

    public void setTotalImport(String totalImport) {
        this.totalImport = StringUtil.trunc(totalImport, 13);
    }

    public String getCurrencyCode() {
        return currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = StringUtil.trunc(currencyCode, 5);
    }

    public String getPayerCode() {
        return payerCode;
    }

    public void setPayerCode(String payerCode) {
        this.payerCode = StringUtil.trunc(payerCode, 10);
    }

    public String getExpDays() {
        return expDays;
    }

    public void setExpDays(String expDays) {
        this.expDays = StringUtil.trunc(expDays, 5);
    }

    public String getNumDocument() {
        return numDocument;
    }

    public void setNumDocument(String numDocument) {
        this.numDocument = StringUtil.trunc(numDocument, 10);
    }

    public Date getDocDate() {
        return docDate;
    }

    public void setDocDate(Date docDate) {
        this.docDate = docDate;
    }

    public String getFolio() {
        return folio;
    }

    public void setFolio(String folio) {
        this.folio = StringUtil.trunc(folio, 30);
    }

    public String getTextExp() {
        return textExp;
    }

    public void setTextExp(String textExp) {
        this.textExp = StringUtil.trunc(textExp, 40);
    }

    public String getLocalImport() {
        return localImport;
    }

    public void setLocalImport(String localImport) {
        this.localImport = StringUtil.trunc(localImport, 13);
    }

    public String getCompanyCode() {
        return companyCode;
    }

    public void setCompanyCode(String companyCode) {
        this.companyCode = StringUtil.trunc(companyCode, 4);
    }

    public Date getExpDate() {
        return expDate;
    }

    public void setExpDate(Date expDate) {
        this.expDate = expDate;
    }

    public String getInvoice() {
        return invoice;
    }

    public void setInvoice(String invoice) {
        this.invoice = StringUtil.trunc(invoice, 10);
    }

    public String getApunteContable() {
        return apunteContable;
    }

    public void setApunteContable(String apunteContable) {
        this.apunteContable = StringUtil.trunc(apunteContable, 3);
    }

    public String getYearDocument() {
        return yearDocument;
    }

    public void setYearDocument(String yearDocument) {
        this.yearDocument = StringUtil.trunc(yearDocument, 4);
    }

    public String getDocVentas() {
        return docVentas;
    }

    public void setDocVentas(String docVentas) {
        this.docVentas = StringUtil.trunc(docVentas, 10);
    }

    public String getApiUpdate() {
        return apiUpdate;
    }

    public void setApiUpdate(String apiUpdate) {
        this.apiUpdate = StringUtil.trunc(apiUpdate, 1);
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = StringUtil.trunc(message, 220);
    }

    public String getIdCme() {
        return idCme;
    }

    public void setIdCme(String idCme) {
        this.idCme = StringUtil.trunc(idCme, 2);
    }

    public String getCheckNumber() {
        return checkNumber;
    }

    public void setCheckNumber(String checkNumber) {
        this.checkNumber = StringUtil.trunc(checkNumber, 18);
    }

    public Date getDueDate() {
        return dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public String getBankKey() {
        return bankKey;
    }

    public void setBankKey(String bankKey) {
        this.bankKey = StringUtil.trunc(bankKey, 15);
    }

    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = StringUtil.trunc(bankName, 30);
    }

    public String getReference() {
        return reference;
    }

    public void setReference(String reference) {
        this.reference = StringUtil.trunc(reference, 16);
    }

    @Override
    public String toString() {
        return "Document [" +
                ((secTransmition != null) ? "secTransmition='" + secTransmition + "', " : "") +
                ((importe != null) ? "importe='" + importe + "', " : "") +
                ((typeDoc != null) ? "typeDoc='" + typeDoc + "', " : "") +
                ((description != null) ? "description='" + description + "', " : "") +
                ((postingKey != null) ? "postingKey='" + postingKey + "', " : "") +
                ((totalImport != null) ? "totalImport='" + totalImport + "', " : "") +
                ((currencyCode != null) ? "currencyCode='" + currencyCode + "', " : "") +
                ((payerCode != null) ? "payerCode='" + payerCode + "', " : "") +
                ((expDays != null) ? "expDays='" + expDays + "', " : "") +
                ((numDocument != null) ? "numDocument='" + numDocument + "', " : "") +
                ((docDate != null) ? "docDate='" + docDate + "', " : "") +
                ((folio != null) ? "folio='" + folio + "', " : "") +
                ((textExp != null) ? "textExp='" + textExp + "', " : "") +
                ((localImport != null) ? "localImport='" + localImport + "', " : "") +
                ((companyCode != null) ? "companyCode='" + companyCode + "', " : "") +
                ((expDate != null) ? "expDate='" + expDate + "', " : "") +
                ((invoice != null) ? "invoice='" + invoice + "', " : "") +
                ((apunteContable != null) ? "apunteContable='" + apunteContable + "', " : "") +
                ((yearDocument != null) ? "yearDocument='" + yearDocument + "', " : "") +
                ((docVentas != null) ? "docVentas='" + docVentas + "', " : "") +
                ((apiUpdate != null) ? "apiUpdate='" + apiUpdate + "', " : "") +
                ((message != null) ? "message='" + message + "', " : "") +
                ((idCme != null) ? "idCme='" + idCme + "', " : "") +
                ((checkNumber != null) ? "checkNumber='" + checkNumber + "', " : "") +
                ((dueDate != null) ? "dueDate='" + dueDate + "', " : "") +
                ((bankKey != null) ? "bankKey='" + bankKey + "', " : "") +
                ((bankName != null) ? "bankName='" + bankName + "', " : "") +
                ((reference != null) ? "reference='" + reference + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Document document = (Document) o;
        return Objects.equals(secTransmition, document.secTransmition) && Objects.equals(importe, document.importe) && Objects.equals(typeDoc, document.typeDoc) && Objects.equals(description, document.description) && Objects.equals(postingKey, document.postingKey) && Objects.equals(totalImport, document.totalImport) && Objects.equals(currencyCode, document.currencyCode) && Objects.equals(payerCode, document.payerCode) && Objects.equals(expDays, document.expDays) && Objects.equals(numDocument, document.numDocument) && Objects.equals(docDate, document.docDate) && Objects.equals(folio, document.folio) && Objects.equals(textExp, document.textExp) && Objects.equals(localImport, document.localImport) && Objects.equals(companyCode, document.companyCode) && Objects.equals(expDate, document.expDate) && Objects.equals(invoice, document.invoice) && Objects.equals(apunteContable, document.apunteContable) && Objects.equals(yearDocument, document.yearDocument) && Objects.equals(docVentas, document.docVentas) && Objects.equals(apiUpdate, document.apiUpdate) && Objects.equals(message, document.message) && Objects.equals(idCme, document.idCme) && Objects.equals(checkNumber, document.checkNumber) && Objects.equals(dueDate, document.dueDate) && Objects.equals(bankKey, document.bankKey) && Objects.equals(bankName, document.bankName) && Objects.equals(reference, document.reference);
    }

    @Override
    public int hashCode() {
        return Objects.hash(secTransmition, importe, typeDoc, description, postingKey, totalImport, currencyCode, payerCode, expDays, numDocument, docDate, folio, textExp, localImport, companyCode, expDate, invoice, apunteContable, yearDocument, docVentas, apiUpdate, message, idCme, checkNumber, dueDate, bankKey, bankName, reference);
    }
}

class CustomDateDeserializer extends JsonDeserializer<Date> {

    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");

    static {
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT-03:00"));
    }

    @Override
    public Date deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        String date = jsonParser.getText();
        try {
            return dateFormat.parse(date);
        } catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}

class CustomDateSerializer extends JsonSerializer<Date> {

    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");

    static {
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT-03:00"));
    }

    @Override
    public void serialize(Date date, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeString(dateFormat.format(date));
    }
}