/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.hlcmapi.core;

import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import ar.com.sdd.commons.rest.model.TokenOAuth2;
import ar.com.sdd.commons.rest.util.RestConnectorUtil;
import ar.com.sdd.hlcmapi.core.HlcmApiConnectorContext;
import ar.com.sdd.hlcmapi.io.InvoicesRequest;
import ar.com.sdd.hlcmapi.io.InvoicesResponse;
import ar.com.sdd.hlcmapi.io.PaymentOrderRequest;
import ar.com.sdd.hlcmapi.io.PaymentOrderResponse;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Form;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HlcmApiConnector
implements RestSecurityManager {
    private final Logger log = LogManager.getLogger(HlcmApiConnector.class);
    private final RestConnector restConnector;
    private final String apiKey;
    private final String username;
    private final String password;
    private final String loginUrl;
    private RequestMethod currentMethod;

    public HlcmApiConnector(HlcmApiConnectorContext context) {
        this.apiKey = context.getApiKey();
        this.username = context.getUsername();
        this.password = context.getPassword();
        this.loginUrl = context.getLoginUrl();
        this.log.debug("Creando HlcmConnector para url [" + context.getBaseUrl() + "] con apiKey [" + this.apiKey + "]");
        RestConnectorEnvironment environment = new RestConnectorEnvironment(context.getBaseUrl());
        this.restConnector = new RestConnector(environment, (RestSecurityManager)this);
    }

    private String getAccessToken() throws RestConnectorException {
        this.log.debug("[getAccessToken] Por recuperar token con username [" + this.username + "] y password [" + this.password.replaceAll(".(?=.{5})", "*") + "]");
        RestConnectorEnvironment environment = new RestConnectorEnvironment(this.loginUrl);
        RestConnector connector = new RestConnector(environment, new RestSecurityManager(){

            public Invocation.Builder addHeaders(Invocation.Builder builder) throws RestConnectorException {
                if (builder != null) {
                    builder.header("Authorization", (Object)RestConnectorUtil.getBasicAuthHeader((String)HlcmApiConnector.this.username, (String)HlcmApiConnector.this.password));
                }
                return builder;
            }

            public boolean getDisableHTTPSErrors() {
                return false;
            }
        });
        TokenOAuth2 tokenOAuth2Response = (TokenOAuth2)connector.genericPost((Object)new Form("grant_type", "client_credentials"), TokenOAuth2.class, "", "application/json", "application/x-www-form-urlencoded");
        this.log.debug("[getAccessToken] Token recuperado [" + tokenOAuth2Response.getAccessToken() + "]");
        return tokenOAuth2Response.getAccessToken();
    }

    public InvoicesResponse getInvoices(String companyCode, String payerCode) throws RestConnectorException {
        this.currentMethod = RequestMethod.GET_INVOICES;
        String path = "/v1/invoices";
        InvoicesRequest invoicesRequest = new InvoicesRequest(companyCode, payerCode);
        this.log.debug("[getInvoices] Request POST getInvoices para el companyCode [" + companyCode + "], payerCode [" + payerCode + "] con path [/v1/invoices]");
        return (InvoicesResponse)this.restConnector.genericPost((Object)invoicesRequest, InvoicesResponse.class, "/v1/invoices");
    }

    public PaymentOrderResponse postPayments(PaymentOrderRequest paymentOrderRequest) throws RestConnectorException {
        this.currentMethod = RequestMethod.POST_PAYMENT;
        String path = "/v1/payment/order";
        this.log.debug("[getInvoices] Request POST payment para " + paymentOrderRequest + " con path [/v1/payment/order]");
        return (PaymentOrderResponse)this.restConnector.genericPost((Object)paymentOrderRequest, PaymentOrderResponse.class, "/v1/payment/order");
    }

    public Invocation.Builder addHeaders(Invocation.Builder builder) throws RestConnectorException {
        if (builder != null) {
            if (RequestMethod.GET_INVOICES.equals((Object)this.currentMethod)) {
                builder.header("Authorization", (Object)this.getAccessToken());
            }
            if (RequestMethod.POST_PAYMENT.equals((Object)this.currentMethod)) {
                builder.header("Authorization", (Object)this.apiKey);
            }
        }
        return builder;
    }

    public boolean getDisableHTTPSErrors() {
        return false;
    }

    private static enum RequestMethod {
        GET_INVOICES,
        POST_PAYMENT;

    }
}

