package ar.com.sdd.hlcmapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class EPayment implements Serializable {

    @JsonProperty("import")
    private String importe;

    @JsonProperty("mod_data")
    private String modData;

    @JsonProperty("id_client")
    private String idClient;

    @JsonProperty("description")
    private String description;

    @JsonProperty("language")
    private Integer language;

    @JsonProperty("telephone")
    private Integer telephone;

    @JsonProperty("pay_system")
    private String paySystem;

    @JsonProperty("year_comp")
    private String yearComp;

    @JsonProperty("hour_mod")
    private String hourMod;

    @JsonProperty("payer_code")
    private String payerCode;

    @JsonProperty("crea_data")
    private String creaData;

    @JsonProperty("hour_crea")
    private String hourCrea;

    @JsonProperty("finance")
    private Integer finance;

    @JsonProperty("payment_method")
    private String paymentMethod;

    @JsonProperty("email")
    private String email;

    @JsonProperty("year_document")
    private String yearDocument;

    public String getImporte() {
        return importe;
    }

    public void setImporte(String importe) {
        this.importe = importe;
    }

    public String getModData() {
        return modData;
    }

    public void setModData(String modData) {
        this.modData = modData;
    }

    public String getIdClient() {
        return idClient;
    }

    public void setIdClient(String idClient) {
        this.idClient = idClient;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getLanguage() {
        return language;
    }

    public void setLanguage(Integer language) {
        this.language = language;
    }

    public Integer getTelephone() {
        return telephone;
    }

    public void setTelephone(Integer telephone) {
        this.telephone = telephone;
    }

    public String getPaySystem() {
        return paySystem;
    }

    public void setPaySystem(String paySystem) {
        this.paySystem = paySystem;
    }

    public String getYearComp() {
        return yearComp;
    }

    public void setYearComp(String yearComp) {
        this.yearComp = yearComp;
    }

    public String getHourMod() {
        return hourMod;
    }

    public void setHourMod(String hourMod) {
        this.hourMod = hourMod;
    }

    public String getPayerCode() {
        return payerCode;
    }

    public void setPayerCode(String payerCode) {
        this.payerCode = payerCode;
    }

    public String getCreaData() {
        return creaData;
    }

    public void setCreaData(String creaData) {
        this.creaData = creaData;
    }

    public String getHourCrea() {
        return hourCrea;
    }

    public void setHourCrea(String hourCrea) {
        this.hourCrea = hourCrea;
    }

    public Integer getFinance() {
        return finance;
    }

    public void setFinance(Integer finance) {
        this.finance = finance;
    }

    public String getPaymentMethod() {
        return paymentMethod;
    }

    public void setPaymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getYearDocument() {
        return yearDocument;
    }

    public void setYearDocument(String yearDocument) {
        this.yearDocument = yearDocument;
    }

    @Override
    public String toString() {
        return "EPayment [" +
                ((importe != null) ? "importe='" + importe + "', " : "") +
                ((modData != null) ? "modData='" + modData + "', " : "") +
                ((idClient != null) ? "idClient='" + idClient + "', " : "") +
                ((description != null) ? "description='" + description + "', " : "") +
                ((language != null) ? "language=" + language + ", " : "") +
                ((telephone != null) ? "telephone=" + telephone + ", " : "") +
                ((paySystem != null) ? "paySystem='" + paySystem + "', " : "") +
                ((yearComp != null) ? "yearComp='" + yearComp + "', " : "") +
                ((hourMod != null) ? "hourMod='" + hourMod + "', " : "") +
                ((payerCode != null) ? "payerCode='" + payerCode + "', " : "") +
                ((creaData != null) ? "creaData='" + creaData + "', " : "") +
                ((hourCrea != null) ? "hourCrea='" + hourCrea + "', " : "") +
                ((finance != null) ? "finance=" + finance + ", " : "") +
                ((paymentMethod != null) ? "paymentMethod='" + paymentMethod + "', " : "") +
                ((email != null) ? "email='" + email + "', " : "") +
                ((yearDocument != null) ? "yearDocument='" + yearDocument + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        EPayment ePayment = (EPayment) o;
        return Objects.equals(importe, ePayment.importe) && Objects.equals(modData, ePayment.modData) && Objects.equals(idClient, ePayment.idClient) && Objects.equals(description, ePayment.description) && Objects.equals(language, ePayment.language) && Objects.equals(telephone, ePayment.telephone) && Objects.equals(paySystem, ePayment.paySystem) && Objects.equals(yearComp, ePayment.yearComp) && Objects.equals(hourMod, ePayment.hourMod) && Objects.equals(payerCode, ePayment.payerCode) && Objects.equals(creaData, ePayment.creaData) && Objects.equals(hourCrea, ePayment.hourCrea) && Objects.equals(finance, ePayment.finance) && Objects.equals(paymentMethod, ePayment.paymentMethod) && Objects.equals(email, ePayment.email) && Objects.equals(yearDocument, ePayment.yearDocument);
    }

    @Override
    public int hashCode() {
        return Objects.hash(importe, modData, idClient, description, language, telephone, paySystem, yearComp, hourMod, payerCode, creaData, hourCrea, finance, paymentMethod, email, yearDocument);
    }
}