package ar.com.sdd.hlcmapi.io;

import ar.com.sdd.hlcmapi.model.Document;
import ar.com.sdd.hlcmapi.model.EPayment;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class InvoicesResponse implements Serializable {

    @JsonProperty("E_PAYMENTS")
    private List<EPayment> ePayments;

    @JsonProperty("DOCUMENTS")
    private List<Document> documents;

    public List<EPayment> getePayments() {
        return ePayments;
    }

    public void setePayments(List<EPayment> ePayments) {
        this.ePayments = ePayments;
    }

    public List<Document> getDocuments() {
        return documents;
    }

    public void setDocuments(List<Document> documents) {
        this.documents = documents;
    }

    @Override
    public String toString() {
        return "InvoicesResponse [" +
                ((ePayments != null) ? "ePayments=" + Arrays.toString(ePayments.toArray()) + ", " : "") +
                ((documents != null) ? "documents=" + Arrays.toString(documents.toArray()) + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        InvoicesResponse that = (InvoicesResponse) o;
        return Objects.equals(ePayments, that.ePayments) && Objects.equals(documents, that.documents);
    }

    @Override
    public int hashCode() {
        return Objects.hash(ePayments, documents);
    }
}