package ar.com.sdd.hlcmapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Document implements Serializable {

    @JsonProperty("sec_transmition")
    private String secTransmition;

    @JsonProperty("import")
    private String importe;

    @JsonProperty("type_doc")
    private String typeDoc;

    @JsonProperty("description")
    private String description;

    @JsonProperty("posting_key")
    private String postingKey;

    @JsonProperty("total_import")
    private String totalImport;

    @JsonProperty("currency_code")
    private String currencyCode;

    @JsonProperty("payer_code")
    private String payerCode;

    @JsonProperty("exp_days")
    private String expDays;

    @JsonProperty("num_document")
    private String numDocument;

    @JsonProperty("doc_date")
    private String docDate;

    @JsonProperty("folio")
    private String folio;

    @JsonProperty("text_exp")
    private String textExp;

    @JsonProperty("local_import")
    private String localImport;

    @JsonProperty("company_code")
    private String companyCode;

    @JsonProperty("exp_date")
    private String expDate;

    @JsonProperty("invoice")
    private String invoice;

    @JsonProperty("apunte_contable")
    private String apunteContable;

    @JsonProperty("year_document")
    private String yearDocument;

    @JsonProperty("doc_ventas")
    private String docVentas;

    @JsonProperty("api_update")
    private String apiUpdate;

    @JsonProperty("message")
    private String message;

    @JsonProperty("id_cme")
    private String idCme;

    @JsonProperty("check_number")
    private String checkNumber;

    @JsonProperty("due_date")
    private String dueDate;

    @JsonProperty("bank_Key")
    private String bankKey;

    @JsonProperty("bank_name")
    private String bankName;

    @JsonProperty("reference")
    private String reference;

    public String getSecTransmition() {
        return secTransmition;
    }

    public void setSecTransmition(String secTransmition) {
        this.secTransmition = secTransmition;
    }

    public String getImporte() {
        return importe;
    }

    public void setImporte(String importe) {
        this.importe = importe;
    }

    public String getTypeDoc() {
        return typeDoc;
    }

    public void setTypeDoc(String typeDoc) {
        this.typeDoc = typeDoc;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getPostingKey() {
        return postingKey;
    }

    public void setPostingKey(String postingKey) {
        this.postingKey = postingKey;
    }

    public String getTotalImport() {
        return totalImport;
    }

    public void setTotalImport(String totalImport) {
        this.totalImport = totalImport;
    }

    public String getCurrencyCode() {
        return currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public String getPayerCode() {
        return payerCode;
    }

    public void setPayerCode(String payerCode) {
        this.payerCode = payerCode;
    }

    public String getExpDays() {
        return expDays;
    }

    public void setExpDays(String expDays) {
        this.expDays = expDays;
    }

    public String getNumDocument() {
        return numDocument;
    }

    public void setNumDocument(String numDocument) {
        this.numDocument = numDocument;
    }

    public String getDocDate() {
        return docDate;
    }

    public void setDocDate(String docDate) {
        this.docDate = docDate;
    }

    public String getFolio() {
        return folio;
    }

    public void setFolio(String folio) {
        this.folio = folio;
    }

    public String getTextExp() {
        return textExp;
    }

    public void setTextExp(String textExp) {
        this.textExp = textExp;
    }

    public String getLocalImport() {
        return localImport;
    }

    public void setLocalImport(String localImport) {
        this.localImport = localImport;
    }

    public String getCompanyCode() {
        return companyCode;
    }

    public void setCompanyCode(String companyCode) {
        this.companyCode = companyCode;
    }

    public String getExpDate() {
        return expDate;
    }

    public void setExpDate(String expDate) {
        this.expDate = expDate;
    }

    public String getInvoice() {
        return invoice;
    }

    public void setInvoice(String invoice) {
        this.invoice = invoice;
    }

    public String getApunteContable() {
        return apunteContable;
    }

    public void setApunteContable(String apunteContable) {
        this.apunteContable = apunteContable;
    }

    public String getYearDocument() {
        return yearDocument;
    }

    public void setYearDocument(String yearDocument) {
        this.yearDocument = yearDocument;
    }

    public String getDocVentas() {
        return docVentas;
    }

    public void setDocVentas(String docVentas) {
        this.docVentas = docVentas;
    }

    public String getApiUpdate() {
        return apiUpdate;
    }

    public void setApiUpdate(String apiUpdate) {
        this.apiUpdate = apiUpdate;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getIdCme() {
        return idCme;
    }

    public void setIdCme(String idCme) {
        this.idCme = idCme;
    }

    public String getCheckNumber() {
        return checkNumber;
    }

    public void setCheckNumber(String checkNumber) {
        this.checkNumber = checkNumber;
    }

    public String getDueDate() {
        return dueDate;
    }

    public void setDueDate(String dueDate) {
        this.dueDate = dueDate;
    }

    public String getBankKey() {
        return bankKey;
    }

    public void setBankKey(String bankKey) {
        this.bankKey = bankKey;
    }

    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public String getReference() {
        return reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    @Override
    public String toString() {
        return "Document [" +
                ((secTransmition != null) ? "secTransmition='" + secTransmition + "', " : "") +
                ((importe != null) ? "importe='" + importe + "', " : "") +
                ((typeDoc != null) ? "typeDoc='" + typeDoc + "', " : "") +
                ((description != null) ? "description='" + description + "', " : "") +
                ((postingKey != null) ? "postingKey='" + postingKey + "', " : "") +
                ((totalImport != null) ? "totalImport='" + totalImport + "', " : "") +
                ((currencyCode != null) ? "currencyCode='" + currencyCode + "', " : "") +
                ((payerCode != null) ? "payerCode='" + payerCode + "', " : "") +
                ((expDays != null) ? "expDays='" + expDays + "', " : "") +
                ((numDocument != null) ? "numDocument='" + numDocument + "', " : "") +
                ((docDate != null) ? "docDate='" + docDate + "', " : "") +
                ((folio != null) ? "folio='" + folio + "', " : "") +
                ((textExp != null) ? "textExp='" + textExp + "', " : "") +
                ((localImport != null) ? "localImport='" + localImport + "', " : "") +
                ((companyCode != null) ? "companyCode='" + companyCode + "', " : "") +
                ((expDate != null) ? "expDate='" + expDate + "', " : "") +
                ((invoice != null) ? "invoice='" + invoice + "', " : "") +
                ((apunteContable != null) ? "apunteContable='" + apunteContable + "', " : "") +
                ((yearDocument != null) ? "yearDocument='" + yearDocument + "', " : "") +
                ((docVentas != null) ? "docVentas='" + docVentas + "', " : "") +
                ((apiUpdate != null) ? "apiUpdate='" + apiUpdate + "', " : "") +
                ((message != null) ? "message='" + message + "', " : "") +
                ((idCme != null) ? "idCme='" + idCme + "', " : "") +
                ((checkNumber != null) ? "checkNumber='" + checkNumber + "', " : "") +
                ((dueDate != null) ? "dueDate='" + dueDate + "', " : "") +
                ((bankKey != null) ? "bankKey='" + bankKey + "', " : "") +
                ((bankName != null) ? "bankName='" + bankName + "', " : "") +
                ((reference != null) ? "reference='" + reference + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Document document = (Document) o;
        return Objects.equals(secTransmition, document.secTransmition) && Objects.equals(importe, document.importe) && Objects.equals(typeDoc, document.typeDoc) && Objects.equals(description, document.description) && Objects.equals(postingKey, document.postingKey) && Objects.equals(totalImport, document.totalImport) && Objects.equals(currencyCode, document.currencyCode) && Objects.equals(payerCode, document.payerCode) && Objects.equals(expDays, document.expDays) && Objects.equals(numDocument, document.numDocument) && Objects.equals(docDate, document.docDate) && Objects.equals(folio, document.folio) && Objects.equals(textExp, document.textExp) && Objects.equals(localImport, document.localImport) && Objects.equals(companyCode, document.companyCode) && Objects.equals(expDate, document.expDate) && Objects.equals(invoice, document.invoice) && Objects.equals(apunteContable, document.apunteContable) && Objects.equals(yearDocument, document.yearDocument) && Objects.equals(docVentas, document.docVentas) && Objects.equals(apiUpdate, document.apiUpdate) && Objects.equals(message, document.message) && Objects.equals(idCme, document.idCme) && Objects.equals(checkNumber, document.checkNumber) && Objects.equals(dueDate, document.dueDate) && Objects.equals(bankKey, document.bankKey) && Objects.equals(bankName, document.bankName) && Objects.equals(reference, document.reference);
    }

    @Override
    public int hashCode() {
        return Objects.hash(secTransmition, importe, typeDoc, description, postingKey, totalImport, currencyCode, payerCode, expDays, numDocument, docDate, folio, textExp, localImport, companyCode, expDate, invoice, apunteContable, yearDocument, docVentas, apiUpdate, message, idCme, checkNumber, dueDate, bankKey, bankName, reference);
    }
}