package ar.com.sdd.hlcmapi.io;

import ar.com.sdd.hlcmapi.model.Document;
import ar.com.sdd.hlcmapi.model.EPayment;
import ar.com.sdd.hlcmapi.model.Payment;
import ar.com.sdd.hlcmapi.model.Return;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PaymentOrderRequest implements Serializable {

    @JsonProperty("PAYMENT")
    private Payment payment;

    @JsonProperty("DOCUMENTS")
    private List<Document> documents;

    public Payment getPayment() {
        return payment;
    }

    public void setPayment(Payment payment) {
        this.payment = payment;
    }

    public List<Document> getDocuments() {
        return documents;
    }

    public void setDocuments(List<Document> documents) {
        this.documents = documents;
    }

    @Override
    public String toString() {
        return "PaymentOrderRequest [" +
                ((payment != null) ? "payment=" + payment + ", " : "") +
                ((documents != null) ? "documents=" + Arrays.toString(documents.toArray()) + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PaymentOrderRequest that = (PaymentOrderRequest) o;
        return Objects.equals(payment, that.payment) && Objects.equals(documents, that.documents);
    }

    @Override
    public int hashCode() {
        return Objects.hash(payment, documents);
    }
}