package ar.com.sdd.hlcmapi.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@SuppressWarnings("unused")
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Payment implements Serializable {

    @JsonProperty("m_client")
    @Size(max = 3)
    private String mClient;

    @JsonProperty("sec_transmition")
    @Size(max = 16)
    private String secTransmition;

    @JsonProperty("payer_code")
    @Size(max = 20)
    private String payerCode;

    @JsonProperty("id_client")
    @Size(max = 5)
    private String idClient;

    @JsonProperty("level_client")
    @Size(max = 5)
    private String levelClient;

    @JsonProperty("type_service")
    @Size(max = 35)
    private String typeService;

    @JsonProperty("import")
    @Size(max = 9)
    private String importe;

    @JsonProperty("description")
    @Size(max = 50)
    private String description;

    @JsonProperty("currency_code")
    @Size(max = 3)
    private String currencyCode;

    @JsonProperty("language")
    @Size(max = 1)
    private String language;

    @JsonProperty("finance")
    @Size(max = 1)
    private String finance;

    @JsonProperty("profile_finan")
    @Size(max = 100)
    private String profileFinan;

    @JsonProperty("email")
    @Size(max = 50)
    private String email;

    @JsonProperty("telephone")
    @Size(max = 30)
    private String telephone;

    @JsonProperty("exp_date")
    @Size(max = 10)
    private String expDate;

    @JsonProperty("payment_method")
    @Size(max = 2)
    private String paymentMethod;

    @JsonProperty("code_approval")
    @Size(max = 8)
    private String codeApproval;

    @JsonProperty("folio_mp")
    @Size(max = 50)
    private String folioMp;

    @JsonProperty("hour")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss.SSSSSS", timezone = "GMT-03:00")
    @Size(max = 26)
    private Date hour;

    @JsonProperty("hour_date")
    @Size(max = 50)
    private String hourDate;

    @JsonProperty("state_interfaz")
    @Size(max = 2)
    private String stateInterfaz;

    @JsonProperty("error_descrip")
    @Size(max = 500)
    private String errorDescrip;

    @JsonProperty("company_code")
    @Size(max = 4)
    private String companyCode;

    @JsonProperty("comp_document")
    @Size(max = 10)
    private String compDocument;

    @JsonProperty("year_comp")
    @Size(max = 4)
    private String yearComp;

    @JsonProperty("mod_data")
    @Size(max = 8)
    private String modData;

    @JsonProperty("hour_mod")
    @Size(max = 6)
    private String hourMod;

    @JsonProperty("user_mod")
    @Size(max = 12)
    private String userMod;

    @JsonProperty("eraser")
    @Size(max = 1)
    private String eraser;

    @JsonProperty("crea_data")
    @Size(max = 1)
    private String creaData;

    @JsonProperty("hour_crea")
    @Size(max = 6)
    private String hourCrea;

    @JsonProperty("user_crea")
    @Size(max = 12)
    private String userCrea;

    @JsonProperty("indic_clear")
    @Size(max = 1)
    private String indicClear;

    @JsonProperty("num_document")
    @Size(max = 10)
    private String numDocument;

    @JsonProperty("year_document")
    @Size(max = 4)
    private String yearDocument;

    @JsonProperty("pay_system")
    @Size(max = 2)
    private String paySystem;

    @JsonProperty("conveniocie")
    @Size(max = 7)
    private String convenioCie;

    @JsonProperty("nif")
    @Size(max = 16)
    private String nif;

    @JsonProperty("invoice")
    @Size(max = 10)
    private String invoice;

    @JsonProperty("discount")
    @Size(max = 13)
    private String discount;

    @JsonProperty("business_area")
    @Size(max = 4)
    private String businessArea;

    @JsonProperty("Payment_flow")
    @Size(max = 2)
    private String paymentFlow;

    @JsonProperty("Region")
    @Size(max = 3)
    private String region;

    public String getmClient() {
        return mClient;
    }

    public void setmClient(String mClient) {
        this.mClient = mClient;
    }

    public String getSecTransmition() {
        return secTransmition;
    }

    public void setSecTransmition(String secTransmition) {
        this.secTransmition = secTransmition;
    }

    public String getPayerCode() {
        return payerCode;
    }

    public void setPayerCode(String payerCode) {
        this.payerCode = payerCode;
    }

    public String getIdClient() {
        return idClient;
    }

    public void setIdClient(String idClient) {
        this.idClient = idClient;
    }

    public String getLevelClient() {
        return levelClient;
    }

    public void setLevelClient(String levelClient) {
        this.levelClient = levelClient;
    }

    public String getTypeService() {
        return typeService;
    }

    public void setTypeService(String typeService) {
        this.typeService = typeService;
    }

    public String getImporte() {
        return importe;
    }

    public void setImporte(String importe) {
        this.importe = importe;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCurrencyCode() {
        return currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public String getLanguage() {
        return language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getFinance() {
        return finance;
    }

    public void setFinance(String finance) {
        this.finance = finance;
    }

    public String getProfileFinan() {
        return profileFinan;
    }

    public void setProfileFinan(String profileFinan) {
        this.profileFinan = profileFinan;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getTelephone() {
        return telephone;
    }

    public void setTelephone(String telephone) {
        this.telephone = telephone;
    }

    public String getExpDate() {
        return expDate;
    }

    public void setExpDate(String expDate) {
        this.expDate = expDate;
    }

    public String getPaymentMethod() {
        return paymentMethod;
    }

    public void setPaymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public String getCodeApproval() {
        return codeApproval;
    }

    public void setCodeApproval(String codeApproval) {
        this.codeApproval = codeApproval;
    }

    public String getFolioMp() {
        return folioMp;
    }

    public void setFolioMp(String folioMp) {
        this.folioMp = folioMp;
    }

    public Date getHour() {
        return hour;
    }

    public void setHour(Date hour) {
        this.hour = hour;
    }

    public String getHourDate() {
        return hourDate;
    }

    public void setHourDate(String hourDate) {
        this.hourDate = hourDate;
    }

    public String getStateInterfaz() {
        return stateInterfaz;
    }

    public void setStateInterfaz(String stateInterfaz) {
        this.stateInterfaz = stateInterfaz;
    }

    public String getErrorDescrip() {
        return errorDescrip;
    }

    public void setErrorDescrip(String errorDescrip) {
        this.errorDescrip = errorDescrip;
    }

    public String getCompanyCode() {
        return companyCode;
    }

    public void setCompanyCode(String companyCode) {
        this.companyCode = companyCode;
    }

    public String getCompDocument() {
        return compDocument;
    }

    public void setCompDocument(String compDocument) {
        this.compDocument = compDocument;
    }

    public String getYearComp() {
        return yearComp;
    }

    public void setYearComp(String yearComp) {
        this.yearComp = yearComp;
    }

    public String getModData() {
        return modData;
    }

    public void setModData(String modData) {
        this.modData = modData;
    }

    public String getHourMod() {
        return hourMod;
    }

    public void setHourMod(String hourMod) {
        this.hourMod = hourMod;
    }

    public String getUserMod() {
        return userMod;
    }

    public void setUserMod(String userMod) {
        this.userMod = userMod;
    }

    public String getEraser() {
        return eraser;
    }

    public void setEraser(String eraser) {
        this.eraser = eraser;
    }

    public String getCreaData() {
        return creaData;
    }

    public void setCreaData(String creaData) {
        this.creaData = creaData;
    }

    public String getHourCrea() {
        return hourCrea;
    }

    public void setHourCrea(String hourCrea) {
        this.hourCrea = hourCrea;
    }

    public String getUserCrea() {
        return userCrea;
    }

    public void setUserCrea(String userCrea) {
        this.userCrea = userCrea;
    }

    public String getIndicClear() {
        return indicClear;
    }

    public void setIndicClear(String indicClear) {
        this.indicClear = indicClear;
    }

    public String getNumDocument() {
        return numDocument;
    }

    public void setNumDocument(String numDocument) {
        this.numDocument = numDocument;
    }

    public String getYearDocument() {
        return yearDocument;
    }

    public void setYearDocument(String yearDocument) {
        this.yearDocument = yearDocument;
    }

    public String getPaySystem() {
        return paySystem;
    }

    public void setPaySystem(String paySystem) {
        this.paySystem = paySystem;
    }

    public String getConvenioCie() {
        return convenioCie;
    }

    public void setConvenioCie(String convenioCie) {
        this.convenioCie = convenioCie;
    }

    public String getNif() {
        return nif;
    }

    public void setNif(String nif) {
        this.nif = nif;
    }

    public String getInvoice() {
        return invoice;
    }

    public void setInvoice(String invoice) {
        this.invoice = invoice;
    }

    public String getDiscount() {
        return discount;
    }

    public void setDiscount(String discount) {
        this.discount = discount;
    }

    public String getBusinessArea() {
        return businessArea;
    }

    public void setBusinessArea(String businessArea) {
        this.businessArea = businessArea;
    }

    public String getPaymentFlow() {
        return paymentFlow;
    }

    public void setPaymentFlow(String paymentFlow) {
        this.paymentFlow = paymentFlow;
    }

    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    @Override
    public String toString() {
        return "Payment [" +
                ((mClient != null) ? "mClient='" + mClient + "', " : "") +
                ((secTransmition != null) ? "secTransmition='" + secTransmition + "', " : "") +
                ((payerCode != null) ? "payerCode='" + payerCode + "', " : "") +
                ((idClient != null) ? "idClient='" + idClient + "', " : "") +
                ((levelClient != null) ? "levelClient='" + levelClient + "', " : "") +
                ((typeService != null) ? "typeService='" + typeService + "', " : "") +
                ((importe != null) ? "importe=" + importe + ", " : "") +
                ((description != null) ? "description='" + description + "', " : "") +
                ((currencyCode != null) ? "currencyCode='" + currencyCode + "', " : "") +
                ((language != null) ? "language='" + language + "', " : "") +
                ((finance != null) ? "finance='" + finance + "', " : "") +
                ((profileFinan != null) ? "profileFinan='" + profileFinan + "', " : "") +
                ((email != null) ? "email='" + email + "', " : "") +
                ((telephone != null) ? "telephone='" + telephone + "', " : "") +
                ((expDate != null) ? "expDate='" + expDate + "', " : "") +
                ((paymentMethod != null) ? "paymentMethod='" + paymentMethod + "', " : "") +
                ((codeApproval != null) ? "codeApproval='" + codeApproval + "', " : "") +
                ((folioMp != null) ? "folioMp='" + folioMp + "', " : "") +
                ((hour != null) ? "hour='" + hour + "', " : "") +
                ((hourDate != null) ? "hourDate='" + hourDate + "', " : "") +
                ((stateInterfaz != null) ? "stateInterfaz='" + stateInterfaz + "', " : "") +
                ((errorDescrip != null) ? "errorDescrip='" + errorDescrip + "', " : "") +
                ((companyCode != null) ? "companyCode='" + companyCode + "', " : "") +
                ((compDocument != null) ? "compDocument='" + compDocument + "', " : "") +
                ((yearComp != null) ? "yearComp='" + yearComp + "', " : "") +
                ((modData != null) ? "modData='" + modData + "', " : "") +
                ((hourMod != null) ? "hourMod='" + hourMod + "', " : "") +
                ((userMod != null) ? "userMod='" + userMod + "', " : "") +
                ((eraser != null) ? "eraser='" + eraser + "', " : "") +
                ((creaData != null) ? "creaData='" + creaData + "', " : "") +
                ((hourCrea != null) ? "hourCrea='" + hourCrea + "', " : "") +
                ((userCrea != null) ? "userCrea='" + userCrea + "', " : "") +
                ((indicClear != null) ? "indicClear='" + indicClear + "', " : "") +
                ((numDocument != null) ? "numDocument='" + numDocument + "', " : "") +
                ((yearDocument != null) ? "yearDocument='" + yearDocument + "', " : "") +
                ((paySystem != null) ? "paySystem='" + paySystem + "', " : "") +
                ((convenioCie != null) ? "convenioCie='" + convenioCie + "', " : "") +
                ((nif != null) ? "nif='" + nif + "', " : "") +
                ((invoice != null) ? "invoice='" + invoice + "', " : "") +
                ((discount != null) ? "discount='" + discount + "', " : "") +
                ((businessArea != null) ? "businessArea='" + businessArea + "', " : "") +
                ((paymentFlow != null) ? "paymentFlow='" + paymentFlow + "', " : "") +
                ((region != null) ? "region='" + region + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Payment payment = (Payment) o;
        return Objects.equals(mClient, payment.mClient) && Objects.equals(secTransmition, payment.secTransmition) && Objects.equals(payerCode, payment.payerCode) && Objects.equals(idClient, payment.idClient) && Objects.equals(levelClient, payment.levelClient) && Objects.equals(typeService, payment.typeService) && Objects.equals(importe, payment.importe) && Objects.equals(description, payment.description) && Objects.equals(currencyCode, payment.currencyCode) && Objects.equals(language, payment.language) && Objects.equals(finance, payment.finance) && Objects.equals(profileFinan, payment.profileFinan) && Objects.equals(email, payment.email) && Objects.equals(telephone, payment.telephone) && Objects.equals(expDate, payment.expDate) && Objects.equals(paymentMethod, payment.paymentMethod) && Objects.equals(codeApproval, payment.codeApproval) && Objects.equals(folioMp, payment.folioMp) && Objects.equals(hour, payment.hour) && Objects.equals(hourDate, payment.hourDate) && Objects.equals(stateInterfaz, payment.stateInterfaz) && Objects.equals(errorDescrip, payment.errorDescrip) && Objects.equals(companyCode, payment.companyCode) && Objects.equals(compDocument, payment.compDocument) && Objects.equals(yearComp, payment.yearComp) && Objects.equals(modData, payment.modData) && Objects.equals(hourMod, payment.hourMod) && Objects.equals(userMod, payment.userMod) && Objects.equals(eraser, payment.eraser) && Objects.equals(creaData, payment.creaData) && Objects.equals(hourCrea, payment.hourCrea) && Objects.equals(userCrea, payment.userCrea) && Objects.equals(indicClear, payment.indicClear) && Objects.equals(numDocument, payment.numDocument) && Objects.equals(yearDocument, payment.yearDocument) && Objects.equals(paySystem, payment.paySystem) && Objects.equals(convenioCie, payment.convenioCie) && Objects.equals(nif, payment.nif) && Objects.equals(invoice, payment.invoice) && Objects.equals(discount, payment.discount) && Objects.equals(businessArea, payment.businessArea) && Objects.equals(paymentFlow, payment.paymentFlow) && Objects.equals(region, payment.region);
    }

    @Override
    public int hashCode() {
        return Objects.hash(mClient, secTransmition, payerCode, idClient, levelClient, typeService, importe, description, currencyCode, language, finance, profileFinan, email, telephone, expDate, paymentMethod, codeApproval, folioMp, hour, hourDate, stateInterfaz, errorDescrip, companyCode, compDocument, yearComp, modData, hourMod, userMod, eraser, creaData, hourCrea, userCrea, indicClear, numDocument, yearDocument, paySystem, convenioCie, nif, invoice, discount, businessArea, paymentFlow, region);
    }
}