package ar.com.sdd.interbanking.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
public class Deuda {

    private String cuitVendedor;
    private String idCuentaRecaudacion;
    private String cuitPagador;
    private String nroComprobante;
    private String moneda;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyyMMdd")
    private Date fecha1erVencimiento;
    private BigDecimal importe1erVencimiento;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyyMMdd")
    private Date fecha2doVencimiento;
    private BigDecimal importe2dorVencimiento;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyyMMdd")
    private Date fecha3erVencimiento;
    private BigDecimal importe3erVencimiento;
    private String codigoVinculacion;
    private String observacion1;
    private String observacion2;
    private String observacion3;
    private String razonSocial;
    private String domicilio;
    private String localidad;
    private String provincia;
    private String codigoPostal;
    private String codigoBarra;
    private String estado;
    private String eliminado;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyyMMdd")
    private Date fechaAlta;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyyMMdd")
    private Date fechaUltimoEstado;

    public String getCuitVendedor() {
        return cuitVendedor;
    }

    public void setCuitVendedor(String cuitVendedor) {
        this.cuitVendedor = cuitVendedor;
    }

    public String getIdCuentaRecaudacion() {
        return idCuentaRecaudacion;
    }

    public void setIdCuentaRecaudacion(String idCuentaRecaudacion) {
        this.idCuentaRecaudacion = idCuentaRecaudacion;
    }

    public String getCuitPagador() {
        return cuitPagador;
    }

    public void setCuitPagador(String cuitPagador) {
        this.cuitPagador = cuitPagador;
    }

    public String getNroComprobante() {
        return nroComprobante;
    }

    public void setNroComprobante(String nroComprobante) {
        this.nroComprobante = nroComprobante;
    }

    public String getMoneda() {
        return moneda;
    }

    public void setMoneda(String moneda) {
        this.moneda = moneda;
    }

    public Date getFecha1erVencimiento() {
        return fecha1erVencimiento;
    }

    public void setFecha1erVencimiento(Date fecha1erVencimiento) {
        this.fecha1erVencimiento = fecha1erVencimiento;
    }

    public BigDecimal getImporte1erVencimiento() {
        return importe1erVencimiento;
    }

    public void setImporte1erVencimiento(BigDecimal importe1erVencimiento) {
        this.importe1erVencimiento = importe1erVencimiento;
    }

    public Date getFecha2doVencimiento() {
        return fecha2doVencimiento;
    }

    public void setFecha2doVencimiento(Date fecha2doVencimiento) {
        this.fecha2doVencimiento = fecha2doVencimiento;
    }

    public BigDecimal getImporte2dorVencimiento() {
        return importe2dorVencimiento;
    }

    public void setImporte2dorVencimiento(BigDecimal importe2dorVencimiento) {
        this.importe2dorVencimiento = importe2dorVencimiento;
    }

    public Date getFecha3erVencimiento() {
        return fecha3erVencimiento;
    }

    public void setFecha3erVencimiento(Date fecha3erVencimiento) {
        this.fecha3erVencimiento = fecha3erVencimiento;
    }

    public BigDecimal getImporte3erVencimiento() {
        return importe3erVencimiento;
    }

    public void setImporte3erVencimiento(BigDecimal importe3erVencimiento) {
        this.importe3erVencimiento = importe3erVencimiento;
    }

    public String getCodigoVinculacion() {
        return codigoVinculacion;
    }

    public void setCodigoVinculacion(String codigoVinculacion) {
        this.codigoVinculacion = codigoVinculacion;
    }

    public String getObservacion1() {
        return observacion1;
    }

    public void setObservacion1(String observacion1) {
        this.observacion1 = observacion1;
    }

    public String getObservacion2() {
        return observacion2;
    }

    public void setObservacion2(String observacion2) {
        this.observacion2 = observacion2;
    }

    public String getObservacion3() {
        return observacion3;
    }

    public void setObservacion3(String observacion3) {
        this.observacion3 = observacion3;
    }

    public String getRazonSocial() {
        return razonSocial;
    }

    public void setRazonSocial(String razonSocial) {
        this.razonSocial = razonSocial;
    }

    public String getDomicilio() {
        return domicilio;
    }

    public void setDomicilio(String domicilio) {
        this.domicilio = domicilio;
    }

    public String getLocalidad() {
        return localidad;
    }

    public void setLocalidad(String localidad) {
        this.localidad = localidad;
    }

    public String getProvincia() {
        return provincia;
    }

    public void setProvincia(String provincia) {
        this.provincia = provincia;
    }

    public String getCodigoPostal() {
        return codigoPostal;
    }

    public void setCodigoPostal(String codigoPostal) {
        this.codigoPostal = codigoPostal;
    }

    public String getCodigoBarra() {
        return codigoBarra;
    }

    public void setCodigoBarra(String codigoBarra) {
        this.codigoBarra = codigoBarra;
    }

    public String getEstado() {
        return estado;
    }

    public void setEstado(String estado) {
        this.estado = estado;
    }

    public String getEliminado() {
        return eliminado;
    }

    public void setEliminado(String eliminado) {
        this.eliminado = eliminado;
    }

    public Date getFechaAlta() {
        return fechaAlta;
    }

    public void setFechaAlta(Date fechaAlta) {
        this.fechaAlta = fechaAlta;
    }

    public Date getFechaUltimoEstado() {
        return fechaUltimoEstado;
    }

    public void setFechaUltimoEstado(Date fechaUltimoEstado) {
        this.fechaUltimoEstado = fechaUltimoEstado;
    }

    @Override
    public String toString() {
        return "Deuda ["
                + ((cuitVendedor != null) ? "cuitVendedor=" + cuitVendedor + ", " : "")
                + ((idCuentaRecaudacion != null) ? "idCuentaRecaudacion=" + idCuentaRecaudacion + ", " : "")
                + ((cuitPagador != null) ? "cuitPagador=" + cuitPagador + ", " : "")
                + ((nroComprobante != null) ? "nroComprobante=" + nroComprobante + ", " : "")
                + ((moneda != null) ? "moneda=" + moneda + ", " : "")
                + ((fecha1erVencimiento != null) ? "fecha1erVencimiento=" + fecha1erVencimiento + ", " : "")
                + ((importe1erVencimiento != null) ? "importe1erVencimiento=" + importe1erVencimiento + ", " : "")
                + ((fecha2doVencimiento != null) ? "fecha2doVencimiento=" + fecha2doVencimiento + ", " : "")
                + ((importe2dorVencimiento != null) ? "importe2dorVencimiento=" + importe2dorVencimiento + ", " : "")
                + ((fecha3erVencimiento != null) ? "fecha3erVencimiento=" + fecha3erVencimiento + ", " : "")
                + ((importe3erVencimiento != null) ? "importe3erVencimiento=" + importe3erVencimiento + ", " : "")
                + ((codigoVinculacion != null) ? "codigoVinculacion=" + codigoVinculacion + ", " : "")
                + ((observacion1 != null) ? "observacion1=" + observacion1 + ", " : "")
                + ((observacion2 != null) ? "observacion2=" + observacion2 + ", " : "")
                + ((observacion3 != null) ? "observacion3=" + observacion3 + ", " : "")
                + ((razonSocial != null) ? "razonSocial=" + razonSocial + ", " : "")
                + ((domicilio != null) ? "domicilio=" + domicilio + ", " : "")
                + ((localidad != null) ? "localidad=" + localidad + ", " : "")
                + ((provincia != null) ? "provincia=" + provincia + ", " : "")
                + ((codigoPostal != null) ? "codigoPostal=" + codigoPostal + ", " : "")
                + ((codigoBarra != null) ? "codigoBarra=" + codigoBarra + ", " : "")
                + ((estado != null) ? "estado=" + estado + ", " : "")
                + ((eliminado != null) ? "eliminado=" + eliminado + ", " : "")
                + ((fechaAlta != null) ? "fechaAlta=" + fechaAlta + ", " : "")
                + ((fechaUltimoEstado != null) ? "fechaUltimoEstado=" + fechaUltimoEstado : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Deuda deuda = (Deuda) o;
        return Objects.equals(cuitVendedor, deuda.cuitVendedor) &&
                Objects.equals(idCuentaRecaudacion, deuda.idCuentaRecaudacion) &&
                Objects.equals(cuitPagador, deuda.cuitPagador) &&
                Objects.equals(nroComprobante, deuda.nroComprobante) &&
                Objects.equals(moneda, deuda.moneda) &&
                Objects.equals(fecha1erVencimiento, deuda.fecha1erVencimiento) &&
                Objects.equals(importe1erVencimiento, deuda.importe1erVencimiento) &&
                Objects.equals(fecha2doVencimiento, deuda.fecha2doVencimiento) &&
                Objects.equals(importe2dorVencimiento, deuda.importe2dorVencimiento) &&
                Objects.equals(fecha3erVencimiento, deuda.fecha3erVencimiento) &&
                Objects.equals(importe3erVencimiento, deuda.importe3erVencimiento) &&
                Objects.equals(codigoVinculacion, deuda.codigoVinculacion) &&
                Objects.equals(observacion1, deuda.observacion1) &&
                Objects.equals(observacion2, deuda.observacion2) &&
                Objects.equals(observacion3, deuda.observacion3) &&
                Objects.equals(razonSocial, deuda.razonSocial) &&
                Objects.equals(domicilio, deuda.domicilio) &&
                Objects.equals(localidad, deuda.localidad) &&
                Objects.equals(provincia, deuda.provincia) &&
                Objects.equals(codigoPostal, deuda.codigoPostal) &&
                Objects.equals(codigoBarra, deuda.codigoBarra) &&
                Objects.equals(estado, deuda.estado) &&
                Objects.equals(eliminado, deuda.eliminado) &&
                Objects.equals(fechaAlta, deuda.fechaAlta) &&
                Objects.equals(fechaUltimoEstado, deuda.fechaUltimoEstado);
    }

    @Override
    public int hashCode() {
        return Objects.hash(cuitVendedor, idCuentaRecaudacion, cuitPagador, nroComprobante, moneda, fecha1erVencimiento, importe1erVencimiento, fecha2doVencimiento, importe2dorVencimiento, fecha3erVencimiento, importe3erVencimiento, codigoVinculacion, observacion1, observacion2, observacion3, razonSocial, domicilio, localidad, provincia, codigoPostal, codigoBarra, estado, eliminado, fechaAlta, fechaUltimoEstado);
    }
}
