package ar.com.sdd.interbanking.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
public class Listado {

    /**
     * Cantidad de p&aacute;ginas totales para el filtro seleccionado
     */
    private String totalPagina;

    public String getTotalPagina() {
        return totalPagina;
    }

    public void setTotalPagina(String totalPagina) {
        this.totalPagina = totalPagina;
    }

    @Override
    public String toString() {
        return "Listado ["
                + ((totalPagina != null) ? "totalPagina=" + totalPagina : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Listado listado = (Listado) o;
        return Objects.equals(totalPagina, listado.totalPagina);
    }

    @Override
    public int hashCode() {
        return Objects.hash(totalPagina);
    }
}
