package ar.com.sdd.interbanking.io;

import ar.com.sdd.interbanking.entity.Deuda;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
public class PreConfeccionRequest {

    private Long identificadorDeuda;
    private Deuda deuda;

    public Long getIdentificadorDeuda() {
        return identificadorDeuda;
    }

    public void setIdentificadorDeuda(Long identificadorDeuda) {
        this.identificadorDeuda = identificadorDeuda;
    }

    public Deuda getDeuda() {
        return deuda;
    }

    public void setDeuda(Deuda deuda) {
        this.deuda = deuda;
    }

    @Override
    public String toString() {
        return "PreConfeccionRequest ["
                + ((identificadorDeuda != null) ? "identificadorDeuda=" + identificadorDeuda + ", " : "")
                + ((deuda != null) ? "deuda=" + deuda : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PreConfeccionRequest that = (PreConfeccionRequest) o;
        return Objects.equals(identificadorDeuda, that.identificadorDeuda) &&
                Objects.equals(deuda, that.deuda);
    }

    @Override
    public int hashCode() {
        return Objects.hash(identificadorDeuda, deuda);
    }
}
