package ar.com.sdd.interbanking.io;

import ar.com.sdd.interbanking.entity.Listado;
import ar.com.sdd.interbanking.entity.Respuesta;
import ar.com.sdd.interbanking.entity.Transferencia;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.util.Arrays;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
public class TransferenciasResponse {

    private Respuesta[] respuesta;
    private Listado listado;
    private Transferencia[] transferencias;

    public Respuesta[] getRespuesta() {
        return respuesta;
    }

    public void setRespuesta(Respuesta[] respuesta) {
        this.respuesta = respuesta;
    }

    public Listado getListado() {
        return listado;
    }

    public void setListado(Listado listado) {
        this.listado = listado;
    }

    public Transferencia[] getTransferencias() {
        return transferencias;
    }

    public void setTransferencias(Transferencia[] transferencias) {
        this.transferencias = transferencias;
    }

    @Override
    public String toString() {
        return "TransferenciasResponse ["
                + ((respuesta != null) ? "respuesta=" + Arrays.toString(respuesta) + ", " : "")
                + ((listado != null) ? "listado=" + listado + ", " : "")
                + ((transferencias != null) ? "transferencias=" + Arrays.toString(transferencias) : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        TransferenciasResponse that = (TransferenciasResponse) o;
        return Arrays.equals(respuesta, that.respuesta) &&
                Objects.equals(listado, that.listado) &&
                Arrays.equals(transferencias, that.transferencias);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(listado);
        result = 31 * result + Arrays.hashCode(respuesta);
        result = 31 * result + Arrays.hashCode(transferencias);
        return result;
    }
}
