/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.interbanking.core;

import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import ar.com.sdd.commons.rest.model.TokenOAuth2;
import ar.com.sdd.commons.rest.util.QueryBuilder;
import ar.com.sdd.interbanking.core.InterbankingApiConnectorContext;
import ar.com.sdd.interbanking.io.PreConfeccionRequest;
import ar.com.sdd.interbanking.io.PreConfeccionResponse;
import ar.com.sdd.interbanking.io.RendicionesResponse;
import ar.com.sdd.interbanking.io.TransferenciasResponse;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.Date;
import java.util.Map;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Form;
import org.apache.log4j.Logger;

public class InterbankingApiConnector
implements RestSecurityManager {
    private static final Logger log = Logger.getLogger(InterbankingApiConnector.class);
    private RestConnectorEnvironment tokenEnvironment;
    private RestConnectorEnvironment environment;
    private RestConnector restConnector;
    private String grantType;
    private String username;
    private String password;
    private String clientId;
    private String scope;

    public InterbankingApiConnector(InterbankingApiConnectorContext interbankingApiConnectorContext) {
        this.tokenEnvironment = new RestConnectorEnvironment(interbankingApiConnectorContext.getInterbankingApiTokenBaseUrl(), null, null, interbankingApiConnectorContext.getInterbankingApiTrustStorePath(), interbankingApiConnectorContext.getInterbankingApiTrustStorePassword());
        this.environment = new RestConnectorEnvironment(interbankingApiConnectorContext.getInterbankingApiBaseUrl(), null, null, interbankingApiConnectorContext.getInterbankingApiTrustStorePath(), interbankingApiConnectorContext.getInterbankingApiTrustStorePassword());
        this.restConnector = new RestConnector(this.environment, (RestSecurityManager)this);
        this.grantType = interbankingApiConnectorContext.getInterbankingApiGrantType();
        this.username = interbankingApiConnectorContext.getInterbankingApiUsername();
        this.password = interbankingApiConnectorContext.getInterbankingApiPassword();
        this.clientId = interbankingApiConnectorContext.getInterbankingApiClientId();
        this.scope = interbankingApiConnectorContext.getInterbankingApiScope();
        log.debug((Object)("Creando connector InterbankingApi con [tokenBaseUrl='" + this.tokenEnvironment.baseUrl + "',baseUrl='" + this.environment.baseUrl + "',grantType='" + this.grantType + "',username='" + this.username + "',password='" + this.password + "',clientId='" + this.clientId + "',scope='" + this.scope + "']"));
    }

    public PreConfeccionResponse postPreConfeccion(PreConfeccionRequest preConfeccionRequest) throws RestConnectorException {
        log.debug((Object)("[postPreConfeccion] Request POST postPreConfeccion con preConfeccionRequest [" + preConfeccionRequest + "]"));
        PreConfeccionResponse response = (PreConfeccionResponse)this.restConnector.genericPost((Object)preConfeccionRequest, PreConfeccionResponse.class, "/api/recaudador/v1.0.0/deudas/", "application/json", "application/json;charset=UTF-8");
        log.debug((Object)("[postPreConfeccion] Response POST postPreConfeccion [" + response + "]"));
        return response;
    }

    public PreConfeccionResponse deletePreConfeccion(Long identificadorDeuda) throws RestConnectorException {
        log.debug((Object)("[deletePreConfeccion] Request DELETE deletePreConfeccion con identificadorDeuda [" + identificadorDeuda + "]"));
        PreConfeccionResponse response = (PreConfeccionResponse)this.restConnector.genericDelete(null, PreConfeccionResponse.class, "/api/recaudador/v1.0.0/deudas/{identificadorDeuda}", Map.ofEntries(new AbstractMap.SimpleEntry<String, Long>("identificadorDeuda", identificadorDeuda)));
        log.debug((Object)("[postPreConfeccion] Response DELETE deletePreConfeccion [" + response + "]"));
        return response;
    }

    public PreConfeccionResponse getPreConfeccion(Long identificadorDeuda) throws RestConnectorException {
        log.debug((Object)("[getPreConfeccion] Request GET PreConfeccion con identificadorDeuda [" + identificadorDeuda + "]"));
        PreConfeccionResponse response = (PreConfeccionResponse)this.restConnector.genericGet(null, PreConfeccionResponse.class, "/api/recaudador/v1.0.0/deudas/{identificadorDeuda}", "identificadorDeuda", String.valueOf(identificadorDeuda));
        log.debug((Object)("[getPreConfeccion] Response GET PreConfeccion [" + response + "]"));
        return response;
    }

    public RendicionesResponse getRendiciones(Date fecha, String moneda, Integer registrosPorPagina, Integer indiceDePagina) throws RestConnectorException {
        QueryBuilder builder = QueryBuilder.Builder().path("/api/recaudador/v1.0.0/deudas/rendiciones");
        if (fecha != null) {
            builder.add("fecha", new SimpleDateFormat("yyyyMMdd").format(fecha));
        }
        if (moneda != null) {
            if (moneda.equals("ARS") || moneda.equals("USD")) {
                builder.add("moneda", moneda);
            } else {
                log.warn((Object)("La moneda [" + moneda + "] no es valida, solamente se acepta ARS o USD. Se realiza la busqueda sin filtrar por moneda."));
            }
        }
        if (registrosPorPagina != null) {
            if (registrosPorPagina > 0 && registrosPorPagina <= 1000) {
                builder.add("tamano", (Number)registrosPorPagina);
            } else {
                log.warn((Object)"La cantidad de registros por pagina debe ser entre 1 y 1000");
            }
        }
        if (indiceDePagina != null) {
            builder.add("pagina", (Number)indiceDePagina);
        }
        String path = builder.build();
        log.debug((Object)("[getPreConfeccion] Request GET PreConfeccion con fecha [" + fecha + "], moneda [" + moneda + "], registrosPorPagina [" + registrosPorPagina + "], indiceDePagina [" + indiceDePagina + "]"));
        RendicionesResponse response = (RendicionesResponse)this.restConnector.genericGet(null, RendicionesResponse.class, path);
        log.debug((Object)("[getPreConfeccion] Response GET PreConfeccion [" + response + "]"));
        return response;
    }

    public TransferenciasResponse postTransferencias(String cuitVendedor, String cuitPagador, BigDecimal importeDesde, BigDecimal importeHasta, Date fechaDesde, Date fechaHasta, String nroComprobanteDesde, String nroComprobanteHasta, String idDeudaDesde, String idDeudaHasta, String estado) throws RestConnectorException {
        QueryBuilder builder = QueryBuilder.Builder().path("/api/recaudador/v1.0.0/consultas/transferencias");
        if (cuitVendedor != null) {
            builder.add("cuitVendedor", cuitVendedor);
        }
        if (cuitPagador != null) {
            builder.add("cuitPagador", cuitPagador);
        }
        if (importeDesde != null) {
            builder.add("importeDesde", (Number)importeDesde);
        }
        if (importeHasta != null) {
            builder.add("importeHasta", (Number)importeHasta);
        }
        if (fechaDesde != null) {
            builder.add("fechaDesde", fechaDesde);
        }
        if (fechaHasta != null) {
            builder.add("fechaHasta", fechaHasta);
        }
        if (nroComprobanteDesde != null) {
            builder.add("nroComprobanteDesde", nroComprobanteDesde);
        }
        if (nroComprobanteHasta != null) {
            builder.add("nroComprobanteHasta", nroComprobanteHasta);
        }
        if (idDeudaDesde != null) {
            builder.add("idDeudaDesde", idDeudaDesde);
        }
        if (idDeudaHasta != null) {
            builder.add("idDeudaHasta", idDeudaHasta);
        }
        if (estado != null) {
            builder.add("estado", estado);
        }
        log.debug((Object)("[getTransferencias] Request GET Transferencias con cuitVendedor [" + cuitVendedor + "],cuitPagador [" + cuitPagador + "],importeDesde [" + importeDesde + "],importeHasta [" + importeHasta + "],fechaDesde [" + fechaDesde + "],fechaHasta [" + fechaHasta + "],nroComprobanteDesde [" + nroComprobanteDesde + "],nroComprobanteHasta [" + nroComprobanteHasta + "],idDeudaDesde [" + idDeudaDesde + "],idDeudaHasta [" + idDeudaHasta + "],estado [" + estado + "]"));
        TransferenciasResponse response = (TransferenciasResponse)this.restConnector.genericPost(null, TransferenciasResponse.class, builder.build());
        log.debug((Object)("[getTransferencias] Response GET Transferencias [" + response + "]"));
        return response;
    }

    public Invocation.Builder addHeaders(Invocation.Builder builder) throws RestConnectorException {
        TokenOAuth2 token = this.getToken();
        log.trace((Object)("[addHeaders] Token recuperado [" + token + "]"));
        builder.header("Authorization", (Object)("Bearer " + token.getAccessToken()));
        return builder;
    }

    private TokenOAuth2 getToken() throws RestConnectorException {
        Form form = new Form();
        form.param("grant_type", this.grantType);
        form.param("username", this.username);
        form.param("password", this.password);
        form.param("client_id", this.clientId);
        log.debug((Object)("[getToken] Por recuperar token con clientId [" + this.clientId + "], username [" + this.username + "], scope [" + this.scope + "]"));
        RestConnector tokenConnector = new RestConnector(this.tokenEnvironment, (RestSecurityManager)new TokenSecurityManager(this.environment));
        TokenOAuth2 tokenOAuth2Response = (TokenOAuth2)tokenConnector.genericPost((Object)form, TokenOAuth2.class, "/cas/oauth2.0/token?scope=" + this.scope, "application/json", "application/x-www-form-urlencoded");
        log.debug((Object)("[getToken] Token recuperado [" + tokenOAuth2Response + "]"));
        return tokenOAuth2Response;
    }

    public static class TokenSecurityManager
    implements RestSecurityManager {
        RestConnectorEnvironment environment;

        TokenSecurityManager(RestConnectorEnvironment environment) {
            this.environment = environment;
        }

        public Invocation.Builder addHeaders(Invocation.Builder builder) {
            builder.header("service", (Object)(this.environment.baseUrl + "/recaudador.*"));
            return builder;
        }
    }
}

