package ar.com.sdd.interbanking.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
public class Pagos {

    private String nroComprobante;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd")
    private Date fechaPago;
    private String moneda;
    private BigDecimal importePagado;
    private Long comprobantePago;
    private Long comprobantePagoBanco;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd")
    private Date fechaVencimiento;
    private BigDecimal importeVencimiento;
    private Long identificadorDeuda;

    public String getNroComprobante() {
        return nroComprobante;
    }

    public void setNroComprobante(String nroComprobante) {
        this.nroComprobante = nroComprobante;
    }

    public Date getFechaPago() {
        return fechaPago;
    }

    public void setFechaPago(Date fechaPago) {
        this.fechaPago = fechaPago;
    }

    public String getMoneda() {
        return moneda;
    }

    public void setMoneda(String moneda) {
        this.moneda = moneda;
    }

    public BigDecimal getImportePagado() {
        return importePagado;
    }

    public void setImportePagado(BigDecimal importePagado) {
        this.importePagado = importePagado;
    }

    public Long getComprobantePago() {
        return comprobantePago;
    }

    public void setComprobantePago(Long comprobantePago) {
        this.comprobantePago = comprobantePago;
    }

    public Long getComprobantePagoBanco() {
        return comprobantePagoBanco;
    }

    public void setComprobantePagoBanco(Long comprobantePagoBanco) {
        this.comprobantePagoBanco = comprobantePagoBanco;
    }

    public Date getFechaVencimiento() {
        return fechaVencimiento;
    }

    public void setFechaVencimiento(Date fechaVencimiento) {
        this.fechaVencimiento = fechaVencimiento;
    }

    public BigDecimal getImporteVencimiento() {
        return importeVencimiento;
    }

    public void setImporteVencimiento(BigDecimal importeVencimiento) {
        this.importeVencimiento = importeVencimiento;
    }

    public Long getIdentificadorDeuda() {
        return identificadorDeuda;
    }

    public void setIdentificadorDeuda(Long identificadorDeuda) {
        this.identificadorDeuda = identificadorDeuda;
    }

    @Override
    public String toString() {
        return "Pagos ["
                + ((nroComprobante != null) ? "nroComprobante=" + nroComprobante + ", " : "")
                + ((fechaPago != null) ? "fechaPago=" + fechaPago + ", " : "")
                + ((moneda != null) ? "moneda=" + moneda + ", " : "")
                + ((importePagado != null) ? "importePagado=" + importePagado + ", " : "")
                + ((comprobantePago != null) ? "comprobantePago=" + comprobantePago + ", " : "")
                + ((comprobantePagoBanco != null) ? "comprobantePagoBanco=" + comprobantePagoBanco + ", " : "")
                + ((fechaVencimiento != null) ? "fechaVencimiento=" + fechaVencimiento + ", " : "")
                + ((importeVencimiento != null) ? "importeVencimiento=" + importeVencimiento + ", " : "")
                + ((identificadorDeuda != null) ? "identificadorDeuda=" + identificadorDeuda : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Pagos pagos = (Pagos) o;
        return Objects.equals(nroComprobante, pagos.nroComprobante) &&
                Objects.equals(fechaPago, pagos.fechaPago) &&
                Objects.equals(moneda, pagos.moneda) &&
                Objects.equals(importePagado, pagos.importePagado) &&
                Objects.equals(comprobantePago, pagos.comprobantePago) &&
                Objects.equals(comprobantePagoBanco, pagos.comprobantePagoBanco) &&
                Objects.equals(fechaVencimiento, pagos.fechaVencimiento) &&
                Objects.equals(importeVencimiento, pagos.importeVencimiento) &&
                Objects.equals(identificadorDeuda, pagos.identificadorDeuda);
    }

    @Override
    public int hashCode() {
        return Objects.hash(nroComprobante, fechaPago, moneda, importePagado, comprobantePago, comprobantePagoBanco, fechaVencimiento, importeVencimiento, identificadorDeuda);
    }
}
