package ar.com.sdd.interbanking.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.math.BigDecimal;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
public class Transferencia {

    private String descripMotivoRechazo;
    private String cuitPagador;
    private String cuitDeudor;
    private String recaudador;
    private String observacionTef;
    private String numeroCuentaRecaudacion;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd")
    private String fechaPago;
    private Long numeroRedIB;
    private Long numeroInterno;
    private String monedaTransferencia;
    private String codBancoCredito;
    private BigDecimal importe;
    private String estadoParaComunidad;
    private String cuitCuentaRecaudacion;
    private String nroComprobante;
    private Long nroIdentificadorDeDeuda;

    public String getDescripMotivoRechazo() {
        return descripMotivoRechazo;
    }

    public void setDescripMotivoRechazo(String descripMotivoRechazo) {
        this.descripMotivoRechazo = descripMotivoRechazo;
    }

    public String getCuitPagador() {
        return cuitPagador;
    }

    public void setCuitPagador(String cuitPagador) {
        this.cuitPagador = cuitPagador;
    }

    public String getCuitDeudor() {
        return cuitDeudor;
    }

    public void setCuitDeudor(String cuitDeudor) {
        this.cuitDeudor = cuitDeudor;
    }

    public String getRecaudador() {
        return recaudador;
    }

    public void setRecaudador(String recaudador) {
        this.recaudador = recaudador;
    }

    public String getObservacionTef() {
        return observacionTef;
    }

    public void setObservacionTef(String observacionTef) {
        this.observacionTef = observacionTef;
    }

    public String getNumeroCuentaRecaudacion() {
        return numeroCuentaRecaudacion;
    }

    public void setNumeroCuentaRecaudacion(String numeroCuentaRecaudacion) {
        this.numeroCuentaRecaudacion = numeroCuentaRecaudacion;
    }

    public String getFechaPago() {
        return fechaPago;
    }

    public void setFechaPago(String fechaPago) {
        this.fechaPago = fechaPago;
    }

    public Long getNumeroRedIB() {
        return numeroRedIB;
    }

    public void setNumeroRedIB(Long numeroRedIB) {
        this.numeroRedIB = numeroRedIB;
    }

    public Long getNumeroInterno() {
        return numeroInterno;
    }

    public void setNumeroInterno(Long numeroInterno) {
        this.numeroInterno = numeroInterno;
    }

    public String getMonedaTransferencia() {
        return monedaTransferencia;
    }

    public void setMonedaTransferencia(String monedaTransferencia) {
        this.monedaTransferencia = monedaTransferencia;
    }

    public String getCodBancoCredito() {
        return codBancoCredito;
    }

    public void setCodBancoCredito(String codBancoCredito) {
        this.codBancoCredito = codBancoCredito;
    }

    public BigDecimal getImporte() {
        return importe;
    }

    public void setImporte(BigDecimal importe) {
        this.importe = importe;
    }

    public String getEstadoParaComunidad() {
        return estadoParaComunidad;
    }

    public void setEstadoParaComunidad(String estadoParaComunidad) {
        this.estadoParaComunidad = estadoParaComunidad;
    }

    public String getCuitCuentaRecaudacion() {
        return cuitCuentaRecaudacion;
    }

    public void setCuitCuentaRecaudacion(String cuitCuentaRecaudacion) {
        this.cuitCuentaRecaudacion = cuitCuentaRecaudacion;
    }

    public String getNroComprobante() {
        return nroComprobante;
    }

    public void setNroComprobante(String nroComprobante) {
        this.nroComprobante = nroComprobante;
    }

    public Long getNroIdentificadorDeDeuda() {
        return nroIdentificadorDeDeuda;
    }

    public void setNroIdentificadorDeDeuda(Long nroIdentificadorDeDeuda) {
        this.nroIdentificadorDeDeuda = nroIdentificadorDeDeuda;
    }

    @Override
    public String toString() {
        return "Transferencia ["
                + ((descripMotivoRechazo != null) ? "descripMotivoRechazo=" + descripMotivoRechazo + ", " : "")
                + ((cuitPagador != null) ? "cuitPagador=" + cuitPagador + ", " : "")
                + ((cuitDeudor != null) ? "cuitDeudor=" + cuitDeudor + ", " : "")
                + ((recaudador != null) ? "recaudador=" + recaudador + ", " : "")
                + ((observacionTef != null) ? "observacionTef=" + observacionTef + ", " : "")
                + ((numeroCuentaRecaudacion != null) ? "numeroCuentaRecaudacion=" + numeroCuentaRecaudacion + ", " : "")
                + ((fechaPago != null) ? "fechaPago=" + fechaPago + ", " : "")
                + ((numeroRedIB != null) ? "numeroRedIB=" + numeroRedIB + ", " : "")
                + ((numeroInterno != null) ? "numeroInterno=" + numeroInterno + ", " : "")
                + ((monedaTransferencia != null) ? "monedaTransferencia=" + monedaTransferencia + ", " : "")
                + ((codBancoCredito != null) ? "codBancoCredito=" + codBancoCredito + ", " : "")
                + ((importe != null) ? "importe=" + importe + ", " : "")
                + ((estadoParaComunidad != null) ? "estadoParaComunidad=" + estadoParaComunidad + ", " : "")
                + ((cuitCuentaRecaudacion != null) ? "cuitCuentaRecaudacion=" + cuitCuentaRecaudacion + ", " : "")
                + ((nroComprobante != null) ? "nroComprobante=" + nroComprobante + ", " : "")
                + ((nroIdentificadorDeDeuda != null) ? "nroIdentificadorDeDeuda=" + nroIdentificadorDeDeuda : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Transferencia that = (Transferencia) o;
        return Objects.equals(descripMotivoRechazo, that.descripMotivoRechazo) &&
                Objects.equals(cuitPagador, that.cuitPagador) &&
                Objects.equals(cuitDeudor, that.cuitDeudor) &&
                Objects.equals(recaudador, that.recaudador) &&
                Objects.equals(observacionTef, that.observacionTef) &&
                Objects.equals(numeroCuentaRecaudacion, that.numeroCuentaRecaudacion) &&
                Objects.equals(fechaPago, that.fechaPago) &&
                Objects.equals(numeroRedIB, that.numeroRedIB) &&
                Objects.equals(numeroInterno, that.numeroInterno) &&
                Objects.equals(monedaTransferencia, that.monedaTransferencia) &&
                Objects.equals(codBancoCredito, that.codBancoCredito) &&
                Objects.equals(importe, that.importe) &&
                Objects.equals(estadoParaComunidad, that.estadoParaComunidad) &&
                Objects.equals(cuitCuentaRecaudacion, that.cuitCuentaRecaudacion) &&
                Objects.equals(nroComprobante, that.nroComprobante) &&
                Objects.equals(nroIdentificadorDeDeuda, that.nroIdentificadorDeDeuda);
    }

    @Override
    public int hashCode() {
        return Objects.hash(descripMotivoRechazo, cuitPagador, cuitDeudor, recaudador, observacionTef, numeroCuentaRecaudacion, fechaPago, numeroRedIB, numeroInterno, monedaTransferencia, codBancoCredito, importe, estadoParaComunidad, cuitCuentaRecaudacion, nroComprobante, nroIdentificadorDeDeuda);
    }
}
