package ar.com.sdd.interbanking.io;

import ar.com.sdd.interbanking.entity.Deuda;
import ar.com.sdd.interbanking.entity.Respuesta;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.util.Arrays;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
public class DeudaResponse {

    private Long identificadorDeuda;
    private Respuesta[] respuesta;
    private Deuda[] deudas;

    public Long getIdentificadorDeuda() {
        return identificadorDeuda;
    }

    public void setIdentificadorDeuda(Long identificadorDeuda) {
        this.identificadorDeuda = identificadorDeuda;
    }

    public Respuesta[] getRespuesta() {
        return respuesta;
    }

    public void setRespuesta(Respuesta[] respuesta) {
        this.respuesta = respuesta;
    }

    public Deuda[] getDeudas() {
        return deudas;
    }

    public void setDeudas(Deuda[] deudas) {
        this.deudas = deudas;
    }

    @Override
    public String toString() {
        return "DeudaResponse ["
                + ((identificadorDeuda != null) ? "identificadorDeuda=" + identificadorDeuda + ", " : "")
                + ((respuesta != null) ? "respuesta=" + Arrays.toString(respuesta) + ", " : "")
                + ((deudas != null) ? "deudas=" + Arrays.toString(deudas) : "")
                + "]";
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DeudaResponse response = (DeudaResponse) o;
        return Objects.equals(identificadorDeuda, response.identificadorDeuda) &&
                Arrays.equals(respuesta, response.respuesta) &&
                Arrays.equals(deudas, response.deudas);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(identificadorDeuda);
        result = 31 * result + Arrays.hashCode(respuesta);
        result = 31 * result + Arrays.hashCode(deudas);
        return result;
    }
}
