package ar.com.sdd.interbanking.io;

import ar.com.sdd.interbanking.entity.Listado;
import ar.com.sdd.interbanking.entity.Pagos;
import ar.com.sdd.interbanking.entity.Respuesta;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.util.Arrays;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
public class RendicionesResponse {

    private Respuesta respuesta;
    private Listado listado;
    private Pagos[] pagos;

    public Respuesta getRespuesta() {
        return respuesta;
    }

    public void setRespuesta(Respuesta respuesta) {
        this.respuesta = respuesta;
    }

    public Listado getListado() {
        return listado;
    }

    public void setListado(Listado listado) {
        this.listado = listado;
    }

    public Pagos[] getPagos() {
        return pagos;
    }

    public void setPagos(Pagos[] pagos) {
        this.pagos = pagos;
    }

    @Override
    public String toString() {
        return "RendicionesResponse ["
                + ((respuesta != null) ? "respuesta=" + respuesta + ", " : "")
                + ((listado != null) ? "listado=" + listado + ", " : "")
                + ((pagos != null) ? "pagos=" + Arrays.toString(pagos) : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        RendicionesResponse that = (RendicionesResponse) o;
        return Objects.equals(respuesta, that.respuesta) &&
                Objects.equals(listado, that.listado) &&
                Arrays.equals(pagos, that.pagos);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(respuesta, listado);
        result = 31 * result + Arrays.hashCode(pagos);
        return result;
    }
}
