package ar.com.sdd.interbanking.io.financiero_v1;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class CuentasRequest implements Serializable {

    @JsonProperty("banco")
    private String banco;// (mandatory): bank's BCRA code (3 posiciones)


    //Nueva API:
    //DEPRECATED
    @JsonProperty("numeroCuenta")
    private String numeroCuenta;//(mandatory): account number

    @JsonProperty("tipo")
    private String tipo;// (optional): account type. Possible values: CC / CA. Default: CC

    @JsonProperty("moneda")
    private String moneda;//moneda (optional): account currency: $, USD. Default: $

   public String getBanco() {
        return banco;
    }

    public void setBanco(String banco) {
        this.banco = banco;
    }

    public String getNumeroCuenta() {
        return numeroCuenta;
    }

    public void setNumeroCuenta(String numeroCuenta) {
        this.numeroCuenta = numeroCuenta;
    }

    public String getTipo() {
        return tipo;
    }

    public void setTipo(String tipo) {
        this.tipo = tipo;
    }

    public String getMoneda() {
        return moneda;
    }

    public void setMoneda(String moneda) {
        this.moneda = moneda;
    }


    @Override
    public String toString() {
        return "SaldosRequest ["
                + ((banco != null) ? "banco=" + banco + ", " : "")
                + ((numeroCuenta != null) ? "numeroCuenta=" + numeroCuenta + ", " : "")
                + ((tipo != null) ? "tipo=" + tipo + ", " : "")
                + ((moneda != null) ? "moneda=" + moneda + " " : "")

                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CuentasRequest that = (CuentasRequest) o;
        return Objects.equals(banco, that.banco) && Objects.equals(numeroCuenta, that.numeroCuenta) && Objects.equals(tipo, that.tipo) && Objects.equals(moneda, that.moneda);
    }

    @Override
    public int hashCode() {
        return Objects.hash(banco, numeroCuenta, tipo, moneda);
    }
}