package ar.com.sdd.interbanking.io.recaudador;

import ar.com.sdd.interbanking.model.recaudador.*;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.util.Arrays;

@JsonIgnoreProperties(ignoreUnknown = true)
public class TransferenciasResponse {

    private Respuesta[] respuesta;
    private Listado listado;
    private Transferencia[] transferencias;

    public Respuesta[] getRespuesta() {
        return respuesta;
    }

    public void setRespuesta(Respuesta[] respuesta) {
        this.respuesta = respuesta;
    }

    public Listado getListado() {
        return listado;
    }

    public void setListado(Listado listado) {
        this.listado = listado;
    }

    public Transferencia[] getTransferencias() {
        return transferencias;
    }

    public void setTransferencias(Transferencia[] transferencias) {
        this.transferencias = transferencias;
    }

    @Override
    public String toString() {
        return "TransferenciasResponse ["
                + ((respuesta != null) ? "respuesta=" + Arrays.toString(respuesta) + ", " : "")
                + ((listado != null) ? "listado=" + listado + ", " : "")
                + ((transferencias != null) ? "transferencias=" + Arrays.toString(transferencias) : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        TransferenciasResponse that = (TransferenciasResponse) o;

        // Probably incorrect - comparing Object[] arrays with Arrays.equals
        if (!Arrays.equals(respuesta, that.respuesta)) return false;
        if (listado != null ? !listado.equals(that.listado) : that.listado != null) return false;
        // Probably incorrect - comparing Object[] arrays with Arrays.equals
        return Arrays.equals(transferencias, that.transferencias);
    }

    @Override
    public int hashCode() {
        int result = Arrays.hashCode(respuesta);
        result = 31 * result + (listado != null ? listado.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(transferencias);
        return result;
    }
}
