package ar.com.sdd.interbanking.model.financiero_v1;

import ar.com.sdd.commons.util.NumberUtil;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
public class Saldos {

    @JsonProperty("saldoContable")
    private Double saldoContable;

    @JsonProperty("saldoOperativoActual")
    private Double saldoOperativoActual;

    @JsonProperty("saldoOperativoInicial")
    private Double saldoOperativoInicial;

    @JsonProperty("saldoProyectado24hs")
    private Double saldoProyectado24hs;

    @JsonProperty("saldoProyectado48hs")
    private Double saldoProyectado48hs;

    public Double getSaldoContable() {
        return saldoContable;
    }

    public void setSaldoContable(Double saldoContable) {
        this.saldoContable = saldoContable;
    }

    public Double getSaldoOperativoActual() {
        return saldoOperativoActual;
    }

    public void setSaldoOperativoActual(Double saldoOperativoActual) {
        this.saldoOperativoActual = saldoOperativoActual;
    }

    public Double getSaldoOperativoInicial() {
        return saldoOperativoInicial;
    }

    public void setSaldoOperativoInicial(Double saldoOperativoInicial) {
        this.saldoOperativoInicial = saldoOperativoInicial;
    }

    public Double getSaldoProyectado24hs() {
        return saldoProyectado24hs;
    }

    public void setSaldoProyectado24hs(Double saldoProyectado24hs) {
        this.saldoProyectado24hs = saldoProyectado24hs;
    }

    public Double getSaldoProyectado48hs() {
        return saldoProyectado48hs;
    }

    public void setSaldoProyectado48hs(Double saldoProyectado48hs) {
        this.saldoProyectado48hs = saldoProyectado48hs;
    }

    @Override
    public String toString() {
        return "Saldos ["
                + ((saldoContable != null) ? "saldoContable=" + NumberUtil.toString(saldoContable) + ", " : "")
                + ((saldoOperativoActual != null) ? "saldoOperativoActual=" + NumberUtil.toString(saldoOperativoActual) + ", " : "")
                + ((saldoOperativoInicial != null) ? "saldoOperativoInicial=" + NumberUtil.toString(saldoOperativoInicial) + ", " : "")
                + ((saldoProyectado24hs != null) ? "saldoProyectado24hs=" + NumberUtil.toString(saldoProyectado24hs) + ", " : "")
                + ((saldoProyectado48hs != null) ? "saldoProyectado48hs=" + NumberUtil.toString(saldoProyectado48hs) : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Saldos saldos = (Saldos) o;
        return Objects.equals(saldoContable, saldos.saldoContable) && Objects.equals(saldoOperativoActual, saldos.saldoOperativoActual) && Objects.equals(saldoOperativoInicial, saldos.saldoOperativoInicial) && Objects.equals(saldoProyectado24hs, saldos.saldoProyectado24hs) && Objects.equals(saldoProyectado48hs, saldos.saldoProyectado48hs);
    }

    @Override
    public int hashCode() {
        return Objects.hash(saldoContable, saldoOperativoActual, saldoOperativoInicial, saldoProyectado24hs, saldoProyectado48hs);
    }
}