package ar.com.sdd.interbanking.io;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class SaldosRequest implements Serializable {

    @JsonProperty("banco")
    private String banco;// (mandatory): bank's BCRA code (3 posiciones)

    @JsonProperty("numeroCuenta")
    private String numeroCuenta;//(mandatory): account number

    @JsonProperty("tipo")
    private String tipo;// (optional): account type. Possible values: CC / CA. Default: CC

    @JsonProperty("moneda")
    private String moneda;//moneda (optional): account currency: $, USD. Default: $

    @JsonProperty("fechaDesde")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy/MM/dd", timezone = "GMT-03:00")
    private Date fechaDesde;// (optional): start date for searching for historical balances, in format YYYY/MM/DD. Default: sysdate - 64

    @JsonProperty("fechaHasta")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy/MM/dd", timezone = "GMT-03:00")
    private Date fechaHasta;// (optional): end date for the search for historical balances, in a format YYYY/MM/DD. Default: sysdate – 1

    @JsonProperty("registros")
    private Integer registros;// (optional): number of historical balance records to be returned. Default: 64

    @JsonProperty("pagina")
    private Integer pagina;// (optional): page on which to return the "n" records. Default: 1

    public String getBanco() {
        return banco;
    }

    public void setBanco(String banco) {
        this.banco = banco;
    }

    public String getNumeroCuenta() {
        return numeroCuenta;
    }

    public void setNumeroCuenta(String numeroCuenta) {
        this.numeroCuenta = numeroCuenta;
    }

    public String getTipo() {
        return tipo;
    }

    public void setTipo(String tipo) {
        this.tipo = tipo;
    }

    public String getMoneda() {
        return moneda;
    }

    public void setMoneda(String moneda) {
        this.moneda = moneda;
    }

    public Date getFechaDesde() {
        return fechaDesde;
    }

    public void setFechaDesde(Date fechaDesde) {
        this.fechaDesde = fechaDesde;
    }

    public Date getFechaHasta() {
        return fechaHasta;
    }

    public void setFechaHasta(Date fechaHasta) {
        this.fechaHasta = fechaHasta;
    }

    public Integer getRegistros() {
        return registros;
    }

    public void setRegistros(Integer registros) {
        this.registros = registros;
    }

    public Integer getPagina() {
        return pagina;
    }

    public void setPagina(Integer pagina) {
        this.pagina = pagina;
    }

    @Override
    public String toString() {
        return "SaldosRequest ["
                + ((banco != null) ? "banco=" + banco + ", " : "")
                + ((numeroCuenta != null) ? "numeroCuenta=" + numeroCuenta + ", " : "")
                + ((tipo != null) ? "tipo=" + tipo + ", " : "")
                + ((moneda != null) ? "moneda=" + moneda + ", " : "")
                + ((fechaDesde != null) ? "fechaDesde=" + fechaDesde + ", " : "")
                + ((fechaHasta != null) ? "fechaHasta=" + fechaHasta + ", " : "")
                + ((registros != null) ? "registros=" + registros + ", " : "")
                + ((pagina != null) ? "pagina=" + pagina : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SaldosRequest that = (SaldosRequest) o;
        return Objects.equals(banco, that.banco) && Objects.equals(numeroCuenta, that.numeroCuenta) && Objects.equals(tipo, that.tipo) && Objects.equals(moneda, that.moneda) && Objects.equals(fechaDesde, that.fechaDesde) && Objects.equals(fechaHasta, that.fechaHasta) && Objects.equals(registros, that.registros) && Objects.equals(pagina, that.pagina);
    }

    @Override
    public int hashCode() {
        return Objects.hash(banco, numeroCuenta, tipo, moneda, fechaDesde, fechaHasta, registros, pagina);
    }
}