package ar.com.sdd.interbanking.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.Objects;
/*
{"banco":"016","cbu":"0168888100008241930371","denominacion":"STARBUCKS COFFEE ARGENTINA SRL",
 "moneda":"$","nombreBanco":"Citibank","numeroCuenta":"0824193037","tipo":"CC"}
*/
@JsonIgnoreProperties(ignoreUnknown = true)
public class Cuenta {

    @JsonProperty("banco")
    private String banco;

    @JsonProperty("cbu")
    private String cbu;

    @JsonProperty("denominacion")
    private String denominacion;

    @JsonProperty("mondeda")
    private String mondeda;

    @JsonProperty("nombreBanco")
    private String nombreBanco;

    @JsonProperty("numeroCuenta")
    private String numeroCuenta;

    @JsonProperty("tipo")
    private String tipo;

    public String getBanco() {
        return banco;
    }

    public void setBanco(String banco) {
        this.banco = banco;
    }

    public String getCbu() {
        return cbu;
    }

    public void setCbu(String cbu) {
        this.cbu = cbu;
    }

    public String getDenominacion() {
        return denominacion;
    }

    public void setDenominacion(String denominacion) {
        this.denominacion = denominacion;
    }

    public String getMondeda() {
        return mondeda;
    }

    public void setMondeda(String mondeda) {
        this.mondeda = mondeda;
    }

    public String getNombreBanco() {
        return nombreBanco;
    }

    public void setNombreBanco(String nombreBanco) {
        this.nombreBanco = nombreBanco;
    }

    public String getNumeroCuenta() {
        return numeroCuenta;
    }

    public void setNumeroCuenta(String numeroCuenta) {
        this.numeroCuenta = numeroCuenta;
    }

    public String getTipo() {
        return tipo;
    }

    public void setTipo(String tipo) {
        this.tipo = tipo;
    }

    @Override
    public String toString() {
        return "Cuenta [" +
                "banco=" + banco +
                ", cbu=" + cbu +
                ", denominacion=" + denominacion +
                ", mondeda=" + mondeda +
                ", nombreBanco=" + nombreBanco +
                ", numeroCuenta=" + numeroCuenta +
                ", tipo=" + tipo +
                ']';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Cuenta cuenta = (Cuenta) o;
        return Objects.equals(banco, cuenta.banco) && Objects.equals(cbu, cuenta.cbu) && Objects.equals(denominacion, cuenta.denominacion) && Objects.equals(mondeda, cuenta.mondeda) && Objects.equals(nombreBanco, cuenta.nombreBanco) && Objects.equals(numeroCuenta, cuenta.numeroCuenta) && Objects.equals(tipo, cuenta.tipo);
    }

    @Override
    public int hashCode() {
        return Objects.hash(banco, cbu, denominacion, mondeda, nombreBanco, numeroCuenta, tipo);
    }
}