/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.interbanking.core;

import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import ar.com.sdd.commons.rest.model.TokenOAuth2;
import ar.com.sdd.commons.rest.util.QueryBuilder;
import ar.com.sdd.ebfapi.client.io.contrato.inba.DeudaRequest;
import ar.com.sdd.ebfapi.client.io.contrato.inba.DeudaResponse;
import ar.com.sdd.ebfapi.client.io.contrato.inba.RendicionesResponse;
import ar.com.sdd.ebfapi.client.io.contrato.inba.TransferenciasResponse;
import ar.com.sdd.interbanking.core.InterbankingApiConnectorContext;
import ar.com.sdd.interbanking.io.ClientesResponse;
import ar.com.sdd.interbanking.io.CuentasRequest;
import ar.com.sdd.interbanking.io.CuentasResponse;
import ar.com.sdd.interbanking.io.SaldosRequest;
import ar.com.sdd.interbanking.io.SaldosResponse;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.Date;
import java.util.Map;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Form;
import org.apache.log4j.Logger;

public class InterbankingApiConnector
implements RestSecurityManager {
    private static final Logger log = Logger.getLogger(InterbankingApiConnector.class);
    private InterbankingApiConnectorContext.ConnectionMethod connectionMethod;
    private RestConnectorEnvironment tokenEnvironment;
    private RestConnectorEnvironment environment;
    private RestConnector restConnector;
    private String grantType;
    private String username;
    private String password;
    private String clientId;
    private String scope;

    public InterbankingApiConnector(InterbankingApiConnectorContext interbankingApiConnectorContext) {
        this.connectionMethod = interbankingApiConnectorContext.getConnectionMethod();
        if (this.connectionMethod.equals((Object)InterbankingApiConnectorContext.ConnectionMethod.APIKEY)) {
            this.tokenEnvironment = new RestConnectorEnvironment(interbankingApiConnectorContext.getInterbankingApiTokenBaseUrl(), null, null, interbankingApiConnectorContext.getInterbankingApiTrustStorePath(), interbankingApiConnectorContext.getInterbankingApiTrustStorePassword());
            this.environment = new RestConnectorEnvironment(interbankingApiConnectorContext.getInterbankingApiBaseUrl(), null, null, interbankingApiConnectorContext.getInterbankingApiTrustStorePath(), interbankingApiConnectorContext.getInterbankingApiTrustStorePassword());
            this.restConnector = new RestConnector(this.environment, (RestSecurityManager)this);
            this.grantType = interbankingApiConnectorContext.getInterbankingApiGrantType();
            this.username = interbankingApiConnectorContext.getInterbankingApiUsername();
            this.password = interbankingApiConnectorContext.getInterbankingApiPassword();
            this.clientId = interbankingApiConnectorContext.getInterbankingApiClientId();
            this.scope = interbankingApiConnectorContext.getInterbankingApiScope();
            if (this.scope != null) {
                this.scope = this.scope.replace("__COMA__", ",");
            }
        }
        if (this.connectionMethod.equals((Object)InterbankingApiConnectorContext.ConnectionMethod.CERTIFICATE)) {
            this.environment = new RestConnectorEnvironment(interbankingApiConnectorContext.getInterbankingApiBaseUrl(), interbankingApiConnectorContext.getInterbankingApiKeyStorePath(), interbankingApiConnectorContext.getInterbankingApiKeyStorePassword(), interbankingApiConnectorContext.getInterbankingApiTrustStorePath(), interbankingApiConnectorContext.getInterbankingApiTrustStorePassword());
            this.restConnector = new RestConnector(this.environment, (RestSecurityManager)this);
        }
        log.debug((Object)("Creando connector InterbankingApi con [connectionMethod='" + this.connectionMethod + "',tokenBaseUrl='" + (this.tokenEnvironment == null ? "null" : this.tokenEnvironment.baseUrl) + "',baseUrl='" + this.environment.baseUrl + "',grantType='" + this.grantType + "',grantType='" + this.grantType + "',username='" + this.username + "',password='" + this.password + "',clientId='" + this.clientId + "',scope='" + this.scope + "']"));
    }

    public DeudaResponse postDeuda(DeudaRequest deudaRequest) throws RestConnectorException {
        log.debug((Object)("[postDeuda] Request POST deuda con " + deudaRequest));
        DeudaResponse response = (DeudaResponse)this.restConnector.genericPost((Object)deudaRequest, DeudaResponse.class, "/api/recaudador/v1.0.0/deudas/", "application/json", "application/json;charset=UTF-8");
        log.debug((Object)("[postDeuda] Response POST deuda [" + response + "]"));
        return response;
    }

    public DeudaResponse deleteDeuda(Long identificadorDeuda) throws RestConnectorException {
        log.debug((Object)("[deleteDeuda] Request DELETE deuda con identificadorDeuda [" + identificadorDeuda + "]"));
        DeudaResponse response = (DeudaResponse)this.restConnector.genericDelete(null, DeudaResponse.class, "/api/recaudador/v1.0.0/deudas/{identificadorDeuda}", Map.ofEntries(new AbstractMap.SimpleEntry<String, Long>("identificadorDeuda", identificadorDeuda)));
        log.debug((Object)("[deleteDeuda] Response DELETE deuda [" + response + "]"));
        return response;
    }

    public DeudaResponse getDeuda(Long identificadorDeuda) throws RestConnectorException {
        log.debug((Object)("[getDeuda] Request GET deuda con identificadorDeuda [" + identificadorDeuda + "]"));
        DeudaResponse response = (DeudaResponse)this.restConnector.genericGet(null, DeudaResponse.class, "/api/recaudador/v1.0.0/deudas/{identificadorDeuda}", "identificadorDeuda", String.valueOf(identificadorDeuda));
        log.debug((Object)("[getDeuda] Response GET deuda [" + response + "]"));
        return response;
    }

    public RendicionesResponse getRendiciones(Date fecha, String moneda, Integer registrosPorPagina, Integer indiceDePagina) throws RestConnectorException {
        QueryBuilder builder = QueryBuilder.Builder().path("/api/recaudador/v1.0.0/deudas/rendiciones");
        if (fecha == null) {
            log.warn((Object)"La fecha es obligatoria para solicitar las rendiciones a IB");
            return null;
        }
        builder.add("fecha", new SimpleDateFormat("yyyy-MM-dd").format(fecha));
        if (moneda != null) {
            if (moneda.equals("ARS") || moneda.equals("USD")) {
                builder.add("moneda", moneda);
            } else {
                log.warn((Object)("La moneda [" + moneda + "] no es valida, solamente se acepta ARS o USD. Se realiza la busqueda sin filtrar por moneda."));
            }
        }
        if (registrosPorPagina != null) {
            if (registrosPorPagina > 0 && registrosPorPagina <= 1000) {
                builder.add("tamano", (Number)registrosPorPagina);
            } else {
                log.warn((Object)"La cantidad de registros por pagina debe ser entre 1 y 1000");
            }
        }
        if (indiceDePagina != null) {
            builder.add("pagina", (Number)indiceDePagina);
        }
        String path = builder.build();
        log.debug((Object)("[getRendiciones] Request GET rendiciones con fecha [" + fecha + "], moneda [" + moneda + "], registrosPorPagina [" + registrosPorPagina + "], indiceDePagina [" + indiceDePagina + "]"));
        RendicionesResponse response = (RendicionesResponse)this.restConnector.genericGet(null, RendicionesResponse.class, path);
        log.debug((Object)("[getRendiciones] Response GET rendiciones [" + response + "]"));
        return response;
    }

    public TransferenciasResponse postTransferencias(String cuitVendedor, String cuitPagador, BigDecimal importeDesde, BigDecimal importeHasta, Date fechaDesde, Date fechaHasta, String nroComprobanteDesde, String nroComprobanteHasta, String idDeudaDesde, String idDeudaHasta, String estado) throws RestConnectorException {
        QueryBuilder builder = QueryBuilder.Builder().path("/api/recaudador/v1.0.0/consultas/transferencias");
        if (cuitVendedor != null) {
            builder.add("cuitVendedor", cuitVendedor);
        }
        if (cuitPagador != null) {
            builder.add("cuitPagador", cuitPagador);
        }
        if (importeDesde != null) {
            builder.add("importeDesde", (Number)importeDesde);
        }
        if (importeHasta != null) {
            builder.add("importeHasta", (Number)importeHasta);
        }
        if (fechaDesde != null) {
            builder.add("fechaDesde", new SimpleDateFormat("yyyy-MM-dd").format(fechaDesde));
        }
        if (fechaHasta != null) {
            builder.add("fechaHasta", new SimpleDateFormat("yyyy-MM-dd").format(fechaHasta));
        }
        if (nroComprobanteDesde != null) {
            builder.add("nroComprobanteDesde", nroComprobanteDesde);
        }
        if (nroComprobanteHasta != null) {
            builder.add("nroComprobanteHasta", nroComprobanteHasta);
        }
        if (idDeudaDesde != null) {
            builder.add("idDeudaDesde", idDeudaDesde);
        }
        if (idDeudaHasta != null) {
            builder.add("idDeudaHasta", idDeudaHasta);
        }
        if (estado != null) {
            builder.add("estado", estado);
        }
        log.debug((Object)("[postTransferencias] Request POST transferencias con cuitVendedor [" + cuitVendedor + "],cuitPagador [" + cuitPagador + "],importeDesde [" + importeDesde + "],importeHasta [" + importeHasta + "],fechaDesde [" + fechaDesde + "],fechaHasta [" + fechaHasta + "],nroComprobanteDesde [" + nroComprobanteDesde + "],nroComprobanteHasta [" + nroComprobanteHasta + "],idDeudaDesde [" + idDeudaDesde + "],idDeudaHasta [" + idDeudaHasta + "],estado [" + estado + "]"));
        TransferenciasResponse response = (TransferenciasResponse)this.restConnector.genericPost(null, TransferenciasResponse.class, builder.build());
        log.debug((Object)("[postTransferencias] Response POST transferencias [" + response + "]"));
        return response;
    }

    public ClientesResponse getClientes() throws RestConnectorException {
        log.debug((Object)"[getClientes] Request GET clientes");
        ClientesResponse response = (ClientesResponse)this.restConnector.genericGet(null, ClientesResponse.class, "/v1/clientes");
        log.debug((Object)("[getClientes] Response GET cientes [" + response + "]"));
        return response;
    }

    public CuentasResponse getCuentas(String clientCode, CuentasRequest cuentasRequest) throws RestConnectorException {
        log.debug((Object)("[getCuentas] Request GET cuentas con clientCode [" + clientCode + "]"));
        QueryBuilder builder = QueryBuilder.Builder().path("/v1/clientes/{clientId}/cuentas");
        Object requestParamsString = "";
        if (cuentasRequest.getBanco() != null && !"".equals(cuentasRequest.getBanco().trim())) {
            builder.add("banco", cuentasRequest.getBanco());
            requestParamsString = (String)requestParamsString + " banco [" + cuentasRequest.getBanco() + "]";
        }
        if (cuentasRequest.getNumeroCuenta() != null && !"".equals(cuentasRequest.getNumeroCuenta().trim())) {
            builder.add("numeroCuenta", cuentasRequest.getNumeroCuenta());
            requestParamsString = (String)requestParamsString + " numeroCuenta [" + cuentasRequest.getNumeroCuenta() + "]";
        }
        if (cuentasRequest.getTipo() != null && !"".equals(cuentasRequest.getTipo().trim())) {
            builder.add("tipo", cuentasRequest.getTipo());
            requestParamsString = (String)requestParamsString + " tipo [" + cuentasRequest.getTipo() + "]";
        }
        if (cuentasRequest.getMoneda() != null && !"".equals(cuentasRequest.getMoneda().trim())) {
            builder.add("moneda", cuentasRequest.getMoneda());
            requestParamsString = (String)requestParamsString + " moneda [" + cuentasRequest.getMoneda() + "]";
        }
        log.debug((Object)("[getSaldos] Request GET cuentas con " + (String)requestParamsString));
        CuentasResponse response = (CuentasResponse)this.restConnector.genericGet(null, CuentasResponse.class, builder.build(), "clientId", clientCode);
        log.debug((Object)("[getCuentas] Response GET cuentas [" + response + "]"));
        return response;
    }

    public SaldosResponse getSaldos(String clientCode, SaldosRequest saldosRequest) throws RestConnectorException {
        log.debug((Object)("[getSaldos] Request GET saldos con clientCode [" + clientCode + "]"));
        if (saldosRequest == null) {
            log.warn((Object)"[getSaldos] No se realiza la consulta de saldos porque saldosRequest es null");
            return null;
        }
        QueryBuilder builder = QueryBuilder.Builder().path("/v1/clientes/{clientId}/saldos");
        Object requestParamsString = "";
        if (saldosRequest.getBanco() == null || "".equals(saldosRequest.getBanco().trim())) {
            log.warn((Object)"[getSaldos] El codigo de banco es obligatorio para solicitar los saldos a IB");
            return null;
        }
        builder.add("banco", saldosRequest.getBanco());
        requestParamsString = (String)requestParamsString + " banco [" + saldosRequest.getBanco() + "]";
        if (saldosRequest.getNumeroCuenta() == null || "".equals(saldosRequest.getNumeroCuenta().trim())) {
            log.warn((Object)"[getSaldos] El numero de cuenta es obligatorio para solicitar los saldos a IB");
            return null;
        }
        builder.add("numeroCuenta", saldosRequest.getNumeroCuenta());
        requestParamsString = (String)requestParamsString + " numeroCuenta [" + saldosRequest.getNumeroCuenta() + "]";
        if (saldosRequest.getTipo() != null && !"".equals(saldosRequest.getTipo().trim())) {
            builder.add("tipo", saldosRequest.getTipo());
            requestParamsString = (String)requestParamsString + " tipo [" + saldosRequest.getTipo() + "]";
        }
        if (saldosRequest.getMoneda() != null && !"".equals(saldosRequest.getMoneda().trim())) {
            builder.add("moneda", saldosRequest.getMoneda());
            requestParamsString = (String)requestParamsString + " moneda [" + saldosRequest.getMoneda() + "]";
        }
        if (saldosRequest.getFechaDesde() != null) {
            builder.add("fechaDesde", saldosRequest.getFechaDesde());
            requestParamsString = (String)requestParamsString + " fechaDesde [" + saldosRequest.getFechaDesde() + "]";
        }
        if (saldosRequest.getFechaHasta() != null) {
            builder.add("fechaHasta", saldosRequest.getFechaHasta());
            requestParamsString = (String)requestParamsString + " fechaHasta [" + saldosRequest.getFechaHasta() + "]";
        }
        if (saldosRequest.getRegistros() != null) {
            builder.add("registros", (Number)saldosRequest.getRegistros());
            requestParamsString = (String)requestParamsString + " registros [" + saldosRequest.getRegistros() + "]";
        }
        if (saldosRequest.getPagina() != null) {
            builder.add("pagina", (Number)saldosRequest.getPagina());
            requestParamsString = (String)requestParamsString + " pagina [" + saldosRequest.getPagina() + "]";
        }
        String path = builder.build();
        log.debug((Object)("[getSaldos] Request GET rendiciones con " + (String)requestParamsString));
        SaldosResponse response = (SaldosResponse)this.restConnector.genericGet(null, SaldosResponse.class, path, "clientId", clientCode);
        log.debug((Object)("[getSaldos] Response GET rendiciones [" + response + "]"));
        return response;
    }

    public Invocation.Builder addHeaders(Invocation.Builder builder) throws RestConnectorException {
        if (this.connectionMethod.equals((Object)InterbankingApiConnectorContext.ConnectionMethod.APIKEY)) {
            TokenOAuth2 token = this.getToken();
            log.trace((Object)("[addHeaders] Token recuperado [" + token + "]"));
            builder.header("Authorization", (Object)("Bearer " + token.getAccessToken()));
        }
        return builder;
    }

    public boolean getDisableHTTPSErrors() {
        return false;
    }

    private TokenOAuth2 getToken() throws RestConnectorException {
        Form form = new Form();
        form.param("grant_type", this.grantType);
        form.param("username", this.username);
        form.param("password", this.password);
        form.param("client_id", this.clientId);
        log.debug((Object)("[getToken] Por recuperar token con clientId [" + this.clientId + "], username [" + this.username + "], scope [" + this.scope + "]"));
        RestConnector tokenConnector = new RestConnector(this.tokenEnvironment, (RestSecurityManager)new TokenSecurityManager(this.environment));
        TokenOAuth2 tokenOAuth2Response = (TokenOAuth2)tokenConnector.genericPost((Object)form, TokenOAuth2.class, "/cas/oauth2.0/token?scope=" + this.scope, "application/json", "application/x-www-form-urlencoded");
        log.debug((Object)("[getToken] Token recuperado [" + tokenOAuth2Response + "]"));
        return tokenOAuth2Response;
    }

    public static class TokenSecurityManager
    implements RestSecurityManager {
        RestConnectorEnvironment environment;

        TokenSecurityManager(RestConnectorEnvironment environment) {
            this.environment = environment;
        }

        public Invocation.Builder addHeaders(Invocation.Builder builder) {
            builder.header("service", (Object)(this.environment.baseUrl + "/recaudador.*"));
            return builder;
        }

        public boolean getDisableHTTPSErrors() {
            return false;
        }
    }
}

