package ar.com.sdd.interbanking.core;

import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import ar.com.sdd.commons.rest.model.TokenOAuth2;
import ar.com.sdd.commons.rest.util.QueryBuilder;
import ar.com.sdd.ebfapi.client.io.contrato.inba.DeudaRequest;
import ar.com.sdd.ebfapi.client.io.contrato.inba.DeudaResponse;
import ar.com.sdd.ebfapi.client.io.contrato.inba.RendicionesResponse;
import ar.com.sdd.ebfapi.client.io.contrato.inba.TransferenciasResponse;
import ar.com.sdd.interbanking.io.*;
import org.apache.log4j.Logger;

import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Form;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.Date;
import java.util.Map;

@SuppressWarnings("unused")
public class InterbankingApiCertificateConnector implements RestSecurityManager {

    private static final Logger log = Logger.getLogger(InterbankingApiCertificateConnector.class);

    private RestConnectorEnvironment environment;
    private RestConnector restConnector;
    private String clientId; //este es el clienteId asociado a una apiKey

    public InterbankingApiCertificateConnector(InterbankingApiCertificateConnectorContext interbankingApiConnectorContext) {
        this.environment = new RestConnectorEnvironment(
                interbankingApiConnectorContext.getInterbankingApiBaseUrl(),
                interbankingApiConnectorContext.getInterbankingApiKeyStorePath(),
                interbankingApiConnectorContext.getInterbankingApiKeyStorePassword(),
                interbankingApiConnectorContext.getInterbankingApiTrustStorePath(),
                interbankingApiConnectorContext.getInterbankingApiTrustStorePassword());
        this.restConnector = new RestConnector(environment, this);

        log.debug("Creando connector InterbankingApiCertificate con ["
                + "baseUrl='" + this.environment.baseUrl + "',"
                + "clientId='" + this.clientId + "',"
                + "keyStorePath='" + this.environment.keyStorePath + "']");
    }

    public ClientesResponse getClientes() throws RestConnectorException {
        log.debug("[getClientes] Request GET clientes");
        ClientesResponse response = restConnector.genericGet(null, ClientesResponse.class, "/v1/clientes");
        log.debug("[getClientes] Response GET cientes [" + response + "]");
        return response;
    }


    public CuentasResponse  getCuentas(String clientCode, CuentasRequest cuentasRequest) throws RestConnectorException {
        log.debug("[getCuentas] Request GET cuentas con clientCode ["+clientCode+"]");

        QueryBuilder builder = QueryBuilder.Builder().path("/v1/clientes/{clientId}/cuentas");
        String requestParamsString = "";
        if (cuentasRequest.getBanco() != null && !"".equals(cuentasRequest.getBanco().trim())) {
            builder.add("banco", cuentasRequest.getBanco());
            requestParamsString += " banco [" + cuentasRequest.getBanco() + "]";
        }
        if (cuentasRequest.getNumeroCuenta() != null && !"".equals(cuentasRequest.getNumeroCuenta().trim())) {
            builder.add("numeroCuenta", cuentasRequest.getNumeroCuenta());
            requestParamsString += " numeroCuenta [" + cuentasRequest.getNumeroCuenta() + "]";
        }
        if (cuentasRequest.getTipo() != null && !"".equals(cuentasRequest.getTipo().trim())) {
            builder.add("tipo", cuentasRequest.getTipo());
            requestParamsString += " tipo [" + cuentasRequest.getTipo() + "]";
        }
        if (cuentasRequest.getMoneda() != null && !"".equals(cuentasRequest.getMoneda().trim())) {
            builder.add("moneda", cuentasRequest.getMoneda());
            requestParamsString += " moneda [" + cuentasRequest.getMoneda() + "]";
        }
        log.debug("[getSaldos] Request GET cuentas con " + requestParamsString);
        CuentasResponse response = restConnector.genericGet(null, CuentasResponse.class, builder.build(),"clientId", clientCode);
        log.debug("[getCuentas] Response GET cuentas [" + response + "]");
        return response;
    }

    public SaldosResponse getSaldos(String clientCode,SaldosRequest saldosRequest) throws RestConnectorException {
        log.debug("[getSaldos] Request GET saldos con clientCode ["+clientCode+"]");
        if (saldosRequest == null) {
            log.warn("[getSaldos] No se realiza la consulta de saldos porque saldosRequest es null");
            return null;
        }

        QueryBuilder builder = QueryBuilder.Builder().path("/v1/clientes/{clientId}/saldos");
        String requestParamsString = "";
        if (saldosRequest.getBanco() != null && !"".equals(saldosRequest.getBanco().trim())) {
            builder.add("banco", saldosRequest.getBanco());
            requestParamsString += " banco [" + saldosRequest.getBanco() + "]";
        } else {
            log.warn("[getSaldos] El codigo de banco es obligatorio para solicitar los saldos a IB");
            return null;
        }

        if (saldosRequest.getNumeroCuenta() != null && !"".equals(saldosRequest.getNumeroCuenta().trim())) {
            builder.add("numeroCuenta", saldosRequest.getNumeroCuenta());
            requestParamsString += " numeroCuenta [" + saldosRequest.getNumeroCuenta() + "]";
        } else {
            log.warn("[getSaldos] El numero de cuenta es obligatorio para solicitar los saldos a IB");
            return null;
        }

        if (saldosRequest.getTipo() != null && !"".equals(saldosRequest.getTipo().trim())) {
            builder.add("tipo", saldosRequest.getTipo());
            requestParamsString += " tipo [" + saldosRequest.getTipo() + "]";
        }

        if (saldosRequest.getMoneda() != null && !"".equals(saldosRequest.getMoneda().trim())) {
            builder.add("moneda", saldosRequest.getMoneda());
            requestParamsString += " moneda [" + saldosRequest.getMoneda() + "]";
        }

        if (saldosRequest.getFechaDesde() != null) {
            builder.add("fechaDesde", saldosRequest.getFechaDesde());
            requestParamsString += " fechaDesde [" + saldosRequest.getFechaDesde() + "]";
        }

        if (saldosRequest.getFechaHasta() != null) {
            builder.add("fechaHasta", saldosRequest.getFechaHasta());
            requestParamsString += " fechaHasta [" + saldosRequest.getFechaHasta() + "]";
        }

        if (saldosRequest.getRegistros() != null) {
            builder.add("registros", saldosRequest.getRegistros());
            requestParamsString += " registros [" + saldosRequest.getRegistros() + "]";
        }

        if (saldosRequest.getPagina() != null) {
            builder.add("pagina", saldosRequest.getPagina());
            requestParamsString += " pagina [" + saldosRequest.getPagina() + "]";
        }

        String path = builder.build();

        log.debug("[getSaldos] Request GET rendiciones con " + requestParamsString);
        SaldosResponse response = restConnector.genericGet(null, SaldosResponse.class, path, "clientId", clientCode);
        log.debug("[getSaldos] Response GET rendiciones [" + response + "]");
        return response;
    }

    @Override
    public Invocation.Builder addHeaders(Invocation.Builder builder) throws RestConnectorException {
        return builder;
    }

    @Override
    public boolean getDisableHTTPSErrors() {
        return false;
    }

}
