package ar.com.sdd.interbanking.io;

import ar.com.sdd.interbanking.model.Cliente;
import ar.com.sdd.interbanking.model.DatosGenerales;
import ar.com.sdd.interbanking.model.Saldos;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ClientesResponse implements Serializable {

    @JsonProperty("clientes")
    private List<Cliente> clientes;

    public List<Cliente> getClientes() {
        return clientes;
    }

    public void setCliente(List<Cliente> clientes) {
        this.clientes = clientes;
    }


    @Override
    public String toString() {
        return "Cientes ["
                + ((clientes != null) ? "cliente=" + clientes + ", " : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ClientesResponse that = (ClientesResponse) o;
        return Objects.equals(clientes, that.clientes) ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(clientes);
    }
}