package ar.com.sdd.interbanking.io;

import ar.com.sdd.interbanking.model.Cuenta;
import ar.com.sdd.interbanking.model.DatosGenerales;
import ar.com.sdd.interbanking.model.Saldos;
import ar.com.sdd.interbanking.model.SaldosHistoricos;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

/*
{"cuentas":[
  {"banco":"016","cbu":"0168888100009001160128","denominacion":null,"moneda":"$","nombreBanco":"Citibank","numeroCuenta":"0900116012","tipo":"CC"}
 ,{"banco":"016","cbu":"0168888100008234620182","denominacion":"FAST FOOD SUDAMERICANA SA","moneda":"$","nombreBanco":"Citibank","numeroCuenta":"0823462018","tipo":"CC"}
 ,{"banco":"016","cbu":"0168888100008241930371","denominacion":"STARBUCKS COFFEE ARGENTINA SRL","moneda":"$","nombreBanco":"Citibank","numeroCuenta":"0824193037","tipo":"CC"}
 ,{"banco":"016","cbu":"0168888100008071490751","denominacion":"WAL-MART ARGENTINA SRL","moneda":"$","nombreBanco":"Citibank","numeroCuenta":"0807149075","tipo":"CC"}
 ],
 "datosGenerales":{"banco":"Todos","moneda":"Todos","numeroCuenta":"Todos","operacion":"7318871482","registrosDevueltos":4,"tipo":"Todos"}
}
*/
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class CuentasResponse implements Serializable {

    @JsonProperty("cuentas")
    private List<Cuenta> cuentas;

    @JsonProperty("datosGenerales")
    private DatosGenerales datosGenerales;


    public List<Cuenta> getCuentas() {
        return cuentas;
    }

    public void setCuentas(List<Cuenta> cuentas) {
        this.cuentas = cuentas;
    }

    public DatosGenerales getDatosGenerales() {
        return datosGenerales;
    }

    public void setDatosGenerales(DatosGenerales datosGenerales) {
        this.datosGenerales = datosGenerales;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CuentasResponse that = (CuentasResponse) o;
        return Objects.equals(cuentas, that.cuentas) && Objects.equals(datosGenerales, that.datosGenerales);
    }

    @Override
    public int hashCode() {
        return Objects.hash(cuentas, datosGenerales);
    }

    @Override
    public String toString() {
        return "CuentasResponse [" +
                "cuentas=" + Arrays.toString(cuentas.toArray()) +
                ", datosGenerales=" + datosGenerales +
                ']';
    }
}