package ar.com.sdd.interbanking.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.Date;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
public class SaldosHistoricos {

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    @JsonProperty("fecha")
    private Date fecha;

    @JsonProperty("saldoDia")
    private Double saldoDia;

    @JsonProperty("totalCreditos")
    private Double totalCreditos;

    @JsonProperty("totalDebitos")
    private Double totalDebitos;

    public Date getFecha() {
        return fecha;
    }

    public void setFecha(Date fecha) {
        this.fecha = fecha;
    }

    public Double getSaldoDia() {
        return saldoDia;
    }

    public void setSaldoDia(Double saldoDia) {
        this.saldoDia = saldoDia;
    }

    public Double getTotalCreditos() {
        return totalCreditos;
    }

    public void setTotalCreditos(Double totalCreditos) {
        this.totalCreditos = totalCreditos;
    }

    public Double getTotalDebitos() {
        return totalDebitos;
    }

    public void setTotalDebitos(Double totalDebitos) {
        this.totalDebitos = totalDebitos;
    }

    @Override
    public String toString() {
        return "SaldosHistoricos ["
                + ((fecha != null) ? "fecha=" + fecha + ", " : "")
                + ((saldoDia != null) ? "saldoDia=" + saldoDia + ", " : "")
                + ((totalCreditos != null) ? "totalCreditos=" + totalCreditos + ", " : "")
                + ((totalDebitos != null) ? "totalDebitos=" + totalDebitos : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SaldosHistoricos that = (SaldosHistoricos) o;
        return Objects.equals(fecha, that.fecha) && Objects.equals(saldoDia, that.saldoDia) && Objects.equals(totalCreditos, that.totalCreditos) && Objects.equals(totalDebitos, that.totalDebitos);
    }

    @Override
    public int hashCode() {
        return Objects.hash(fecha, saldoDia, totalCreditos, totalDebitos);
    }
}