package ar.com.sdd.interbanking.io.financiero;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class AccountsRequest implements Serializable {
    private String bankNumber;// (mandatory): bank's BCRA code (3 posiciones)
    private String accountType;// (optional): account type. Possible values: CC / CA. Default: CC

    private String accountNumber;// (optional): account number
    private String currency;//moneda (optional): account currency: $, USD. Default: $
    private String limit;//ej: 100
    private String page;//ej: 0

    public String getBankNumber() {
        return bankNumber;
    }

    public void setBankNumber(String bankNumber) {
        this.bankNumber = bankNumber;
    }

    public String getAccountType() {
        return accountType;
    }

    public void setAccountType(String accountType) {
        this.accountType = accountType;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getAccountNumber() {
        return accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public String getLimit() {
        return limit;
    }

    public void setLimit(String limit) {
        this.limit = limit;
    }

    public String getPage() {
        return page;
    }

    public void setPage(String page) {
        this.page = page;
    }



    @Override
    public String toString() {
        return "AccountsRequest [" +
                "bankNumber=" + bankNumber +
                ", accountType=" + accountType +
                ", currency=" + currency +
                ", accountNumber=" + accountNumber +
                ", limit=" + limit +
                ", page=" + page +
                ']';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        AccountsRequest that = (AccountsRequest) o;

        if (!Objects.equals(bankNumber, that.bankNumber)) return false;
        if (!Objects.equals(accountType, that.accountType)) return false;
        if (!Objects.equals(currency, that.currency)) return false;
        if (!Objects.equals(accountNumber, that.accountNumber)) return false;
        if (!Objects.equals(limit, that.limit)) return false;
        return Objects.equals(page, that.page);
    }

    @Override
    public int hashCode() {
        int result = bankNumber != null ? bankNumber.hashCode() : 0;
        result = 31 * result + (accountType != null ? accountType.hashCode() : 0);
        result = 31 * result + (currency != null ? currency.hashCode() : 0);
        result = 31 * result + (accountNumber != null ? accountNumber.hashCode() : 0);
        result = 31 * result + (limit != null ? limit.hashCode() : 0);
        result = 31 * result + (page != null ? page.hashCode() : 0);
        return result;
    }

}