package ar.com.sdd.interbanking.io.financiero;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

/*

1041: No se admiten caracteres especiales
1044: El campo account-type no es válido
1040: La fecha no es una fecha válida
0002: El campo currency no es válida
1006: El campo page/limit debe ser de tipo numérico
0101: El campo customer-id debe ser informado
1038: El campo page debe ser mayor o igual a cero
1022: El campo limit debe ser mayor a cero
1048: La fecha inicial no puede ser mayor que la fecha final
1042: Cliente no encontrado

*/
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class BalanceRequest implements Serializable {

    @JsonProperty("bank-number")
    private String bankNumber;// (mandatory): bank's BCRA code (3 posiciones)

    @JsonProperty("account-number")
    private String accountNumber;//(mandatory): account number

    @JsonProperty("account-type")
    private String accountType;// (optional): account type. Possible values: CC / CA. Default: CC

    @JsonProperty("currency")
    private String currency;//currency (optional): account currency: $, USD. Default: $

    @JsonProperty("date-since")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy/MM/dd", timezone = "GMT-03:00")
    private Date dateSince;// (optional): start date for searching for historical balances, in format YYYY/MM/DD. Default: sysdate - 64

    @JsonProperty("date-until")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy/MM/dd", timezone = "GMT-03:00")
    private Date dateUntil;// (optional): end date for the search for historical balances, in a format YYYY/MM/DD. Default: sysdate – 1

    @JsonProperty("limit")
    private String limit;// (optional): number of historical balance records to be returned. Default: 64

    @JsonProperty("page")
    private String page;// (optional): page on which to return the "n" records. Default: 1

    public String getBankNumber() {
        return bankNumber;
    }

    public void setBankNumber(String bankNumber) {
        this.bankNumber = bankNumber;
    }

    public String getAccountNumber() {
        return accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public String getAccountType() {
        return accountType;
    }

    public void setAccountType(String accountType) {
        this.accountType = accountType;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public Date getDateSince() {
        return dateSince;
    }

    public void setDateSince(Date dateSince) {
        this.dateSince = dateSince;
    }

    public Date getDateUntil() {
        return dateUntil;
    }

    public void setDateUntil(Date dateUntil) {
        this.dateUntil = dateUntil;
    }

    public String getLimit() {
        return limit;
    }

    public void setLimit(String limit) {
        this.limit = limit;
    }

    public String getPage() {
        return page;
    }

    public void setPage(String page) {
        this.page = page;
    }

    @Override
    public String toString() {
        return "SaldosRequest ["
                + ((bankNumber != null) ? "bankNumber=" + bankNumber + ", " : "")
                + ((accountNumber != null) ? "accountNumber=" + accountNumber + ", " : "")
                + ((accountType != null) ? "accountType=" + accountType + ", " : "")
                + ((currency != null) ? "currency=" + currency + ", " : "")
                + ((dateSince != null) ? "dateSince=" + dateSince + ", " : "")
                + ((dateUntil != null) ? "dateUntil=" + dateUntil + ", " : "")
                + ((limit != null) ? "limit=" + limit + ", " : "")
                + ((page != null) ? "page=" + page : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        BalanceRequest that = (BalanceRequest) o;
        return Objects.equals(bankNumber, that.bankNumber) && Objects.equals(accountNumber, that.accountNumber) && Objects.equals(accountType, that.accountType) && Objects.equals(currency, that.currency) && Objects.equals(dateSince, that.dateSince) && Objects.equals(dateUntil, that.dateUntil) && Objects.equals(limit, that.limit) && Objects.equals(page, that.page);
    }

    @Override
    public int hashCode() {
        return Objects.hash(bankNumber, accountNumber, accountType, currency, dateSince, dateUntil, limit, page);
    }
}