package ar.com.sdd.interbanking.io.financiero;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class MovementsRequest implements Serializable {

    @JsonProperty("account-number")
    private String accountNumber;// (mandatory): account number

    @JsonProperty("movement-type")
    private String movementType;// (mandatory): dia/diferidos/anteriores

    @JsonProperty("bank-number")
    private String bankNumber;// (mandatory): bank's BCRA code (3 posiciones)

    @JsonProperty("account-type")
    private String accountType;// (optional): account type. Possible values: CC / CA. Default: CC

    @JsonProperty("currency")
    private String currency;//moneda (optional): account currency: $, USD. Default: $


    @JsonProperty("date-since")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy/MM/dd", timezone = "GMT-03:00")
    private Date dateSince;// (optional): start date for searching for historical balances, in format YYYY/MM/DD. Default: sysdate - 64

    @JsonProperty("date-until")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy/MM/dd", timezone = "GMT-03:00")
    private Date dateUntil;// (optional): end date for the search for historical balances, in a format YYYY/MM/DD. Default: sysdate – 1


    private String limit;//ej: 100
    private String page;//ej: 0

    public String getAccountNumber() {
        return accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public String getMovementType() {
        return movementType;
    }

    public void setMovementType(String movementType) {
        this.movementType = movementType;
    }

    public String getBankNumber() {
        return bankNumber;
    }

    public void setBankNumber(String bankNumber) {
        this.bankNumber = bankNumber;
    }

    public String getAccountType() {
        return accountType;
    }

    public void setAccountType(String accountType) {
        this.accountType = accountType;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public Date getDateSince() {
        return dateSince;
    }

    public void setDateSince(Date dateSince) {
        this.dateSince = dateSince;
    }

    public Date getDateUntil() {
        return dateUntil;
    }

    public void setDateUntil(Date dateUntil) {
        this.dateUntil = dateUntil;
    }

    public String getLimit() {
        return limit;
    }

    public void setLimit(String limit) {
        this.limit = limit;
    }

    public String getPage() {
        return page;
    }

    public void setPage(String page) {
        this.page = page;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        MovementsRequest that = (MovementsRequest) o;

        if (!Objects.equals(accountNumber, that.accountNumber)) return false;
        if (!Objects.equals(movementType, that.movementType)) return false;
        if (!Objects.equals(bankNumber, that.bankNumber)) return false;
        if (!Objects.equals(accountType, that.accountType)) return false;
        if (!Objects.equals(currency, that.currency)) return false;
        if (!Objects.equals(dateSince, that.dateSince)) return false;
        if (!Objects.equals(dateUntil, that.dateUntil)) return false;
        if (!Objects.equals(limit, that.limit)) return false;
        return Objects.equals(page, that.page);
    }

    @Override
    public int hashCode() {
        int result = accountNumber != null ? accountNumber.hashCode() : 0;
        result = 31 * result + (movementType != null ? movementType.hashCode() : 0);
        result = 31 * result + (bankNumber != null ? bankNumber.hashCode() : 0);
        result = 31 * result + (accountType != null ? accountType.hashCode() : 0);
        result = 31 * result + (currency != null ? currency.hashCode() : 0);
        result = 31 * result + (dateSince != null ? dateSince.hashCode() : 0);
        result = 31 * result + (dateUntil != null ? dateUntil.hashCode() : 0);
        result = 31 * result + (limit != null ? limit.hashCode() : 0);
        result = 31 * result + (page != null ? page.hashCode() : 0);
        return result;
    }
}