package ar.com.sdd.interbanking.io.financiero;

import ar.com.sdd.interbanking.model.financiero.AccountBalance;
import ar.com.sdd.interbanking.model.financiero.GeneralData;
import ar.com.sdd.interbanking.model.financiero.MovementDetail;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class MovementsResponse implements Serializable {

    @JsonProperty("general-data")
    private GeneralData generalData;

    @JsonProperty("movements_detail")
    private List<MovementDetail> movementDetails;


    public GeneralData getGeneralData() {
        return generalData;
    }

    public void setGeneralData(GeneralData generalData) {
        this.generalData = generalData;
    }

    public List<MovementDetail> getMovementDetails() {
        return movementDetails;
    }

    public void setMovementDetail(List<MovementDetail> movementDetails) {
        this.movementDetails = movementDetails;
    }

    @Override
    public String toString() {
        return "SaldosResponse ["
                + ((generalData != null) ? "generalData=" + generalData + ", " : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        MovementsResponse that = (MovementsResponse) o;
        return Objects.equals(generalData, that.generalData) && Objects.equals(movementDetails, that.movementDetails);
    }

    @Override
    public int hashCode() {
        return Objects.hash(generalData, movementDetails);
    }
}