package ar.com.sdd.interbanking.io.financiero_v1;

import ar.com.sdd.interbanking.model.financiero_v1.DatosGenerales;
import ar.com.sdd.interbanking.model.financiero_v1.Saldos;
import ar.com.sdd.interbanking.model.financiero_v1.SaldosHistoricos;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class SaldosResponse implements Serializable {

    @JsonProperty("datosGenerales")
    private DatosGenerales datosGenerales;

    @JsonProperty("saldos")
    private Saldos saldos;

    @JsonProperty("saldosHistoricos")
    private List<SaldosHistoricos> saldosHistoricos;

    public DatosGenerales getDatosGenerales() {
        return datosGenerales;
    }

    public void setDatosGenerales(DatosGenerales datosGenerales) {
        this.datosGenerales = datosGenerales;
    }

    public Saldos getSaldos() {
        return saldos;
    }

    public void setSaldos(Saldos saldos) {
        this.saldos = saldos;
    }

    public List<SaldosHistoricos> getSaldosHistoricos() {
        return saldosHistoricos;
    }

    public void setSaldosHistoricos(List<SaldosHistoricos> saldosHistoricos) {
        this.saldosHistoricos = saldosHistoricos;
    }

    @Override
    public String toString() {
        return "SaldosResponse ["
                + ((datosGenerales != null) ? "datosGenerales=" + datosGenerales + ", " : "")
                + ((saldos != null) ? "saldos=" + saldos + ", " : "")
                + ((saldosHistoricos != null) ? "saldosHistoricos=" + Arrays.toString(saldosHistoricos.toArray()) : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SaldosResponse that = (SaldosResponse) o;
        return Objects.equals(datosGenerales, that.datosGenerales) && Objects.equals(saldos, that.saldos) && Objects.equals(saldosHistoricos, that.saldosHistoricos);
    }

    @Override
    public int hashCode() {
        return Objects.hash(datosGenerales, saldos, saldosHistoricos);
    }
}