package ar.com.sdd.interbanking.model.financiero;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.Date;
import java.util.Objects;

/* {
      "account_cbu": "string",
      "depositor_code": "string",
      "operation_code_ib": "string",
      "operation_code_bank": "string",
      "operation_code_standard": "string",
      "code_description_ib": "string",
      "code_description_standard": "string",
      "customer_cuit": "string",
      "depositor_description": "string",
      "code_description_bank": "string",
      "amount": 0,
      "voucher_number": 0,
      "grouping_code_ib": "string",
      "grouping_code_standard": "string",
      "branch_office_activity": "string"
    }
*/
@JsonIgnoreProperties(ignoreUnknown = true)
public class MovementDetail {


    @JsonProperty("account_cbu")
    private String accountCbu;

    @JsonProperty("depositor_code")
    private String depositorCode;

    @JsonProperty("operation_code_ib")
    private String operationCodeIB;

    @JsonProperty("operation_code_bank")
    private String operationCodeBank;

    @JsonProperty("operation_code_standard")
    private String operationCodeStandard;

    @JsonProperty("customer_cuit")
    private String customerCuit;

    @JsonProperty("depositor_description")
    private String depositorDescription;

    @JsonProperty("code_description_bank")
    private String codeDescriptionBank;

    @JsonProperty("amount")
    private Double amount;

    @JsonProperty("voucher_number")
    private String voucherNumber;

    @JsonProperty("grouping_code_ib")
    private String groupingCodeIB;

    @JsonProperty("grouping_code_standard")
    private String groupingCodeStandard;

    @JsonProperty("branch_office_activity")
    private String branchOfficeActivity;

    public String getAccountCbu() {
        return accountCbu;
    }

    public void setAccountCbu(String accountCbu) {
        this.accountCbu = accountCbu;
    }

    public String getDepositorCode() {
        return depositorCode;
    }

    public void setDepositorCode(String depositorCode) {
        this.depositorCode = depositorCode;
    }

    public String getOperationCodeIB() {
        return operationCodeIB;
    }

    public void setOperationCodeIB(String operationCodeIB) {
        this.operationCodeIB = operationCodeIB;
    }

    public String getOperationCodeBank() {
        return operationCodeBank;
    }

    public void setOperationCodeBank(String operationCodeBank) {
        this.operationCodeBank = operationCodeBank;
    }

    public String getOperationCodeStandard() {
        return operationCodeStandard;
    }

    public void setOperationCodeStandard(String operationCodeStandard) {
        this.operationCodeStandard = operationCodeStandard;
    }

    public String getCustomerCuit() {
        return customerCuit;
    }

    public void setCustomerCuit(String customerCuit) {
        this.customerCuit = customerCuit;
    }

    public String getDepositorDescription() {
        return depositorDescription;
    }

    public void setDepositorDescription(String depositorDescription) {
        this.depositorDescription = depositorDescription;
    }

    public String getCodeDescriptionBank() {
        return codeDescriptionBank;
    }

    public void setCodeDescriptionBank(String codeDescriptionBank) {
        this.codeDescriptionBank = codeDescriptionBank;
    }

    public Double getAmount() {
        return amount;
    }

    public void setAmount(Double amount) {
        this.amount = amount;
    }

    public String getVoucherNumber() {
        return voucherNumber;
    }

    public void setVoucherNumber(String voucherNumber) {
        this.voucherNumber = voucherNumber;
    }

    public String getGroupingCodeIB() {
        return groupingCodeIB;
    }

    public void setGroupingCodeIB(String groupingCodeIB) {
        this.groupingCodeIB = groupingCodeIB;
    }

    public String getGroupingCodeStandard() {
        return groupingCodeStandard;
    }

    public void setGroupingCodeStandard(String groupingCodeStandard) {
        this.groupingCodeStandard = groupingCodeStandard;
    }

    public String getBranchOfficeActivity() {
        return branchOfficeActivity;
    }

    public void setBranchOfficeActivity(String branchOfficeActivity) {
        this.branchOfficeActivity = branchOfficeActivity;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        MovementDetail that = (MovementDetail) o;

        if (!Objects.equals(accountCbu, that.accountCbu)) return false;
        if (!Objects.equals(depositorCode, that.depositorCode)) return false;
        if (!Objects.equals(operationCodeIB, that.operationCodeIB)) return false;
        if (!Objects.equals(operationCodeBank, that.operationCodeBank)) return false;
        if (!Objects.equals(operationCodeStandard, that.operationCodeStandard)) return false;
        if (!Objects.equals(customerCuit, that.customerCuit)) return false;
        if (!Objects.equals(depositorDescription, that.depositorDescription)) return false;
        if (!Objects.equals(codeDescriptionBank, that.codeDescriptionBank)) return false;
        if (!Objects.equals(amount, that.amount)) return false;
        if (!Objects.equals(voucherNumber, that.voucherNumber)) return false;
        if (!Objects.equals(groupingCodeIB, that.groupingCodeIB)) return false;
        if (!Objects.equals(groupingCodeStandard, that.groupingCodeStandard)) return false;
        return Objects.equals(branchOfficeActivity, that.branchOfficeActivity);
    }

    @Override
    public int hashCode() {
        int result = accountCbu != null ? accountCbu.hashCode() : 0;
        result = 31 * result + (depositorCode != null ? depositorCode.hashCode() : 0);
        result = 31 * result + (operationCodeIB != null ? operationCodeIB.hashCode() : 0);
        result = 31 * result + (operationCodeBank != null ? operationCodeBank.hashCode() : 0);
        result = 31 * result + (operationCodeStandard != null ? operationCodeStandard.hashCode() : 0);
        result = 31 * result + (customerCuit != null ? customerCuit.hashCode() : 0);
        result = 31 * result + (depositorDescription != null ? depositorDescription.hashCode() : 0);
        result = 31 * result + (codeDescriptionBank != null ? codeDescriptionBank.hashCode() : 0);
        result = 31 * result + (amount != null ? amount.hashCode() : 0);
        result = 31 * result + (voucherNumber != null ? voucherNumber.hashCode() : 0);
        result = 31 * result + (groupingCodeIB != null ? groupingCodeIB.hashCode() : 0);
        result = 31 * result + (groupingCodeStandard != null ? groupingCodeStandard.hashCode() : 0);
        result = 31 * result + (branchOfficeActivity != null ? branchOfficeActivity.hashCode() : 0);
        return result;
    }
}