package ar.com.sdd.interbanking.model.financiero_v1;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.Date;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
public class DatosGenerales {

    @JsonProperty("banco")
    private String banco;// "517",

    @JsonProperty("fechaActualizacion")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date fechaActualizacion;// "2018-08-16T00:00:00",

    @JsonProperty("fechaDesde")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date fechaDesde;// "2018-06-13",

    @JsonProperty("fechaHasta")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date fechaHasta;// "2018-08-15",

    @JsonProperty("moneda")
    private String moneda;// "$",

    @JsonProperty("numeroCuenta")
    private String numeroCuenta;// "0434149100",

    @JsonProperty("operacion")
    private String operacion;// "8909132988",

    @JsonProperty("registrosDevueltos")
    private Integer registrosDevueltos;// 2,

    @JsonProperty("tipo")
    private String tipo;// "CC",

    @JsonProperty("totalRegistros")
    private Integer totalRegistros;// 45

    public String getBanco() {
        return banco;
    }

    public void setBanco(String banco) {
        this.banco = banco;
    }

    public Date getFechaActualizacion() {
        return fechaActualizacion;
    }

    public void setFechaActualizacion(Date fechaActualizacion) {
        this.fechaActualizacion = fechaActualizacion;
    }

    public Date getFechaDesde() {
        return fechaDesde;
    }

    public void setFechaDesde(Date fechaDesde) {
        this.fechaDesde = fechaDesde;
    }

    public Date getFechaHasta() {
        return fechaHasta;
    }

    public void setFechaHasta(Date fechaHasta) {
        this.fechaHasta = fechaHasta;
    }

    public String getMoneda() {
        return moneda;
    }

    public void setMoneda(String moneda) {
        this.moneda = moneda;
    }

    public String getNumeroCuenta() {
        return numeroCuenta;
    }

    public void setNumeroCuenta(String numeroCuenta) {
        this.numeroCuenta = numeroCuenta;
    }

    public String getOperacion() {
        return operacion;
    }

    public void setOperacion(String operacion) {
        this.operacion = operacion;
    }

    public Integer getRegistrosDevueltos() {
        return registrosDevueltos;
    }

    public void setRegistrosDevueltos(Integer registrosDevueltos) {
        this.registrosDevueltos = registrosDevueltos;
    }

    public String getTipo() {
        return tipo;
    }

    public void setTipo(String tipo) {
        this.tipo = tipo;
    }

    public Integer getTotalRegistros() {
        return totalRegistros;
    }

    public void setTotalRegistros(Integer totalRegistros) {
        this.totalRegistros = totalRegistros;
    }

    @Override
    public String toString() {
        return "DatosGenerales ["
                + ((banco != null) ? "banco=" + banco + ", " : "")
                + ((fechaActualizacion != null) ? "fechaActualizacion=" + fechaActualizacion + ", " : "")
                + ((fechaDesde != null) ? "fechaDesde=" + fechaDesde + ", " : "")
                + ((fechaHasta != null) ? "fechaHasta=" + fechaHasta + ", " : "")
                + ((moneda != null) ? "moneda=" + moneda + ", " : "")
                + ((numeroCuenta != null) ? "numeroCuenta=" + numeroCuenta + ", " : "")
                + ((operacion != null) ? "operacion=" + operacion + ", " : "")
                + ((registrosDevueltos != null) ? "registrosDevueltos=" + registrosDevueltos + ", " : "")
                + ((tipo != null) ? "tipo=" + tipo + ", " : "")
                + ((totalRegistros != null) ? "totalRegistros=" + totalRegistros : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DatosGenerales that = (DatosGenerales) o;
        return Objects.equals(banco, that.banco) && Objects.equals(fechaActualizacion, that.fechaActualizacion) && Objects.equals(fechaDesde, that.fechaDesde) && Objects.equals(fechaHasta, that.fechaHasta) && Objects.equals(moneda, that.moneda) && Objects.equals(numeroCuenta, that.numeroCuenta) && Objects.equals(operacion, that.operacion) && Objects.equals(registrosDevueltos, that.registrosDevueltos) && Objects.equals(tipo, that.tipo) && Objects.equals(totalRegistros, that.totalRegistros);
    }

    @Override
    public int hashCode() {
        return Objects.hash(banco, fechaActualizacion, fechaDesde, fechaHasta, moneda, numeroCuenta, operacion, registrosDevueltos, tipo, totalRegistros);
    }
}