package ar.com.sdd.interbanking.model.recaudador;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.math.BigDecimal;
import java.util.Date;

@JsonIgnoreProperties(ignoreUnknown = true)
public class Deuda {

    private String cuitVendedor;
    private String idCuentaRecaudacion;
    private String cuitPagador;
    private String nroComprobante;
    private String moneda;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyyMMdd", timezone = "GMT-03:00")
    private Date fecha1erVencimiento;
    private BigDecimal importe1erVencimiento;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyyMMdd", timezone = "GMT-03:00")
    private Date fecha2doVencimiento;
    private BigDecimal importe2doVencimiento;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyyMMdd", timezone = "GMT-03:00")
    private Date fecha3erVencimiento;
    private BigDecimal importe3erVencimiento;
    private String codigoVinculacion;
    private String observacion1;
    private String observacion2;
    private String observacion3;
    private String razonSocial;
    private String domicilio;
    private String localidad;
    private String provincia;
    private String codigoPostal;
    private String codigoBarra;
    private String estado;
    private String eliminado;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyyMMdd", timezone = "GMT-03:00")
    private Date fechaAlta;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyyMMdd", timezone = "GMT-03:00")
    private Date fechaUltimoEstado;

    public String getCuitVendedor() {
        return cuitVendedor;
    }

    public void setCuitVendedor(String cuitVendedor) {
        this.cuitVendedor = cuitVendedor;
    }

    public String getIdCuentaRecaudacion() {
        return idCuentaRecaudacion;
    }

    public void setIdCuentaRecaudacion(String idCuentaRecaudacion) {
        this.idCuentaRecaudacion = idCuentaRecaudacion;
    }

    public String getCuitPagador() {
        return cuitPagador;
    }

    public void setCuitPagador(String cuitPagador) {
        this.cuitPagador = cuitPagador;
    }

    public String getNroComprobante() {
        return nroComprobante;
    }

    public void setNroComprobante(String nroComprobante) {
        this.nroComprobante = nroComprobante;
    }

    public String getMoneda() {
        return moneda;
    }

    public void setMoneda(String moneda) {
        this.moneda = moneda;
    }

    public Date getFecha1erVencimiento() {
        return fecha1erVencimiento;
    }

    public void setFecha1erVencimiento(Date fecha1erVencimiento) {
        this.fecha1erVencimiento = fecha1erVencimiento;
    }

    public BigDecimal getImporte1erVencimiento() {
        return importe1erVencimiento;
    }

    public void setImporte1erVencimiento(BigDecimal importe1erVencimiento) {
        this.importe1erVencimiento = importe1erVencimiento;
    }

    public Date getFecha2doVencimiento() {
        return fecha2doVencimiento;
    }

    public void setFecha2doVencimiento(Date fecha2doVencimiento) {
        this.fecha2doVencimiento = fecha2doVencimiento;
    }

    public BigDecimal getImporte2doVencimiento() {
        return importe2doVencimiento;
    }

    public void setImporte2doVencimiento(BigDecimal importe2doVencimiento) {
        this.importe2doVencimiento = importe2doVencimiento;
    }

    public Date getFecha3erVencimiento() {
        return fecha3erVencimiento;
    }

    public void setFecha3erVencimiento(Date fecha3erVencimiento) {
        this.fecha3erVencimiento = fecha3erVencimiento;
    }

    public BigDecimal getImporte3erVencimiento() {
        return importe3erVencimiento;
    }

    public void setImporte3erVencimiento(BigDecimal importe3erVencimiento) {
        this.importe3erVencimiento = importe3erVencimiento;
    }

    public String getCodigoVinculacion() {
        return codigoVinculacion;
    }

    public void setCodigoVinculacion(String codigoVinculacion) {
        this.codigoVinculacion = codigoVinculacion;
    }

    public String getObservacion1() {
        return observacion1;
    }

    public void setObservacion1(String observacion1) {
        this.observacion1 = observacion1;
    }

    public String getObservacion2() {
        return observacion2;
    }

    public void setObservacion2(String observacion2) {
        this.observacion2 = observacion2;
    }

    public String getObservacion3() {
        return observacion3;
    }

    public void setObservacion3(String observacion3) {
        this.observacion3 = observacion3;
    }

    public String getRazonSocial() {
        return razonSocial;
    }

    public void setRazonSocial(String razonSocial) {
        this.razonSocial = razonSocial;
    }

    public String getDomicilio() {
        return domicilio;
    }

    public void setDomicilio(String domicilio) {
        this.domicilio = domicilio;
    }

    public String getLocalidad() {
        return localidad;
    }

    public void setLocalidad(String localidad) {
        this.localidad = localidad;
    }

    public String getProvincia() {
        return provincia;
    }

    public void setProvincia(String provincia) {
        this.provincia = provincia;
    }

    public String getCodigoPostal() {
        return codigoPostal;
    }

    public void setCodigoPostal(String codigoPostal) {
        this.codigoPostal = codigoPostal;
    }

    public String getCodigoBarra() {
        return codigoBarra;
    }

    public void setCodigoBarra(String codigoBarra) {
        this.codigoBarra = codigoBarra;
    }

    public String getEstado() {
        return estado;
    }

    public void setEstado(String estado) {
        this.estado = estado;
    }

    public String getEliminado() {
        return eliminado;
    }

    public void setEliminado(String eliminado) {
        this.eliminado = eliminado;
    }

    public Date getFechaAlta() {
        return fechaAlta;
    }

    public void setFechaAlta(Date fechaAlta) {
        this.fechaAlta = fechaAlta;
    }

    public Date getFechaUltimoEstado() {
        return fechaUltimoEstado;
    }

    public void setFechaUltimoEstado(Date fechaUltimoEstado) {
        this.fechaUltimoEstado = fechaUltimoEstado;
    }

    @Override
    public String toString() {
        return "Deuda ["
                + ((cuitVendedor != null) ? "cuitVendedor=" + cuitVendedor + ", " : "")
                + ((idCuentaRecaudacion != null) ? "idCuentaRecaudacion=" + idCuentaRecaudacion + ", " : "")
                + ((cuitPagador != null) ? "cuitPagador=" + cuitPagador + ", " : "")
                + ((nroComprobante != null) ? "nroComprobante=" + nroComprobante + ", " : "")
                + ((moneda != null) ? "moneda=" + moneda + ", " : "")
                + ((fecha1erVencimiento != null) ? "fecha1erVencimiento=" + fecha1erVencimiento + ", " : "")
                + ((importe1erVencimiento != null) ? "importe1erVencimiento=" + importe1erVencimiento + ", " : "")
                + ((fecha2doVencimiento != null) ? "fecha2doVencimiento=" + fecha2doVencimiento + ", " : "")
                + ((importe2doVencimiento != null) ? "importe2doVencimiento=" + importe2doVencimiento + ", " : "")
                + ((fecha3erVencimiento != null) ? "fecha3erVencimiento=" + fecha3erVencimiento + ", " : "")
                + ((importe3erVencimiento != null) ? "importe3erVencimiento=" + importe3erVencimiento + ", " : "")
                + ((codigoVinculacion != null) ? "codigoVinculacion=" + codigoVinculacion + ", " : "")
                + ((observacion1 != null) ? "observacion1=" + observacion1 + ", " : "")
                + ((observacion2 != null) ? "observacion2=" + observacion2 + ", " : "")
                + ((observacion3 != null) ? "observacion3=" + observacion3 + ", " : "")
                + ((razonSocial != null) ? "razonSocial=" + razonSocial + ", " : "")
                + ((domicilio != null) ? "domicilio=" + domicilio + ", " : "")
                + ((localidad != null) ? "localidad=" + localidad + ", " : "")
                + ((provincia != null) ? "provincia=" + provincia + ", " : "")
                + ((codigoPostal != null) ? "codigoPostal=" + codigoPostal + ", " : "")
                + ((codigoBarra != null) ? "codigoBarra=" + codigoBarra + ", " : "")
                + ((estado != null) ? "estado=" + estado + ", " : "")
                + ((eliminado != null) ? "eliminado=" + eliminado + ", " : "")
                + ((fechaAlta != null) ? "fechaAlta=" + fechaAlta + ", " : "")
                + ((fechaUltimoEstado != null) ? "fechaUltimoEstado=" + fechaUltimoEstado : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Deuda deuda = (Deuda) o;

        if (cuitVendedor != null ? !cuitVendedor.equals(deuda.cuitVendedor) : deuda.cuitVendedor != null) return false;
        if (idCuentaRecaudacion != null ? !idCuentaRecaudacion.equals(deuda.idCuentaRecaudacion) : deuda.idCuentaRecaudacion != null) return false;
        if (cuitPagador != null ? !cuitPagador.equals(deuda.cuitPagador) : deuda.cuitPagador != null) return false;
        if (nroComprobante != null ? !nroComprobante.equals(deuda.nroComprobante) : deuda.nroComprobante != null) return false;
        if (moneda != null ? !moneda.equals(deuda.moneda) : deuda.moneda != null) return false;
        if (fecha1erVencimiento != null ? !fecha1erVencimiento.equals(deuda.fecha1erVencimiento) : deuda.fecha1erVencimiento != null) return false;
        if (importe1erVencimiento != null ? !importe1erVencimiento.equals(deuda.importe1erVencimiento) : deuda.importe1erVencimiento != null) return false;
        if (fecha2doVencimiento != null ? !fecha2doVencimiento.equals(deuda.fecha2doVencimiento) : deuda.fecha2doVencimiento != null) return false;
        if (importe2doVencimiento != null ? !importe2doVencimiento.equals(deuda.importe2doVencimiento) : deuda.importe2doVencimiento != null) return false;
        if (fecha3erVencimiento != null ? !fecha3erVencimiento.equals(deuda.fecha3erVencimiento) : deuda.fecha3erVencimiento != null) return false;
        if (importe3erVencimiento != null ? !importe3erVencimiento.equals(deuda.importe3erVencimiento) : deuda.importe3erVencimiento != null) return false;
        if (codigoVinculacion != null ? !codigoVinculacion.equals(deuda.codigoVinculacion) : deuda.codigoVinculacion != null) return false;
        if (observacion1 != null ? !observacion1.equals(deuda.observacion1) : deuda.observacion1 != null) return false;
        if (observacion2 != null ? !observacion2.equals(deuda.observacion2) : deuda.observacion2 != null) return false;
        if (observacion3 != null ? !observacion3.equals(deuda.observacion3) : deuda.observacion3 != null) return false;
        if (razonSocial != null ? !razonSocial.equals(deuda.razonSocial) : deuda.razonSocial != null) return false;
        if (domicilio != null ? !domicilio.equals(deuda.domicilio) : deuda.domicilio != null) return false;
        if (localidad != null ? !localidad.equals(deuda.localidad) : deuda.localidad != null) return false;
        if (provincia != null ? !provincia.equals(deuda.provincia) : deuda.provincia != null) return false;
        if (codigoPostal != null ? !codigoPostal.equals(deuda.codigoPostal) : deuda.codigoPostal != null) return false;
        if (codigoBarra != null ? !codigoBarra.equals(deuda.codigoBarra) : deuda.codigoBarra != null) return false;
        if (estado != null ? !estado.equals(deuda.estado) : deuda.estado != null) return false;
        if (eliminado != null ? !eliminado.equals(deuda.eliminado) : deuda.eliminado != null) return false;
        if (fechaAlta != null ? !fechaAlta.equals(deuda.fechaAlta) : deuda.fechaAlta != null) return false;
        return fechaUltimoEstado != null ? fechaUltimoEstado.equals(deuda.fechaUltimoEstado) : deuda.fechaUltimoEstado == null;
    }

    @Override
    public int hashCode() {
        int result = cuitVendedor != null ? cuitVendedor.hashCode() : 0;
        result = 31 * result + (idCuentaRecaudacion != null ? idCuentaRecaudacion.hashCode() : 0);
        result = 31 * result + (cuitPagador != null ? cuitPagador.hashCode() : 0);
        result = 31 * result + (nroComprobante != null ? nroComprobante.hashCode() : 0);
        result = 31 * result + (moneda != null ? moneda.hashCode() : 0);
        result = 31 * result + (fecha1erVencimiento != null ? fecha1erVencimiento.hashCode() : 0);
        result = 31 * result + (importe1erVencimiento != null ? importe1erVencimiento.hashCode() : 0);
        result = 31 * result + (fecha2doVencimiento != null ? fecha2doVencimiento.hashCode() : 0);
        result = 31 * result + (importe2doVencimiento != null ? importe2doVencimiento.hashCode() : 0);
        result = 31 * result + (fecha3erVencimiento != null ? fecha3erVencimiento.hashCode() : 0);
        result = 31 * result + (importe3erVencimiento != null ? importe3erVencimiento.hashCode() : 0);
        result = 31 * result + (codigoVinculacion != null ? codigoVinculacion.hashCode() : 0);
        result = 31 * result + (observacion1 != null ? observacion1.hashCode() : 0);
        result = 31 * result + (observacion2 != null ? observacion2.hashCode() : 0);
        result = 31 * result + (observacion3 != null ? observacion3.hashCode() : 0);
        result = 31 * result + (razonSocial != null ? razonSocial.hashCode() : 0);
        result = 31 * result + (domicilio != null ? domicilio.hashCode() : 0);
        result = 31 * result + (localidad != null ? localidad.hashCode() : 0);
        result = 31 * result + (provincia != null ? provincia.hashCode() : 0);
        result = 31 * result + (codigoPostal != null ? codigoPostal.hashCode() : 0);
        result = 31 * result + (codigoBarra != null ? codigoBarra.hashCode() : 0);
        result = 31 * result + (estado != null ? estado.hashCode() : 0);
        result = 31 * result + (eliminado != null ? eliminado.hashCode() : 0);
        result = 31 * result + (fechaAlta != null ? fechaAlta.hashCode() : 0);
        result = 31 * result + (fechaUltimoEstado != null ? fechaUltimoEstado.hashCode() : 0);
        return result;
    }
}
