package ar.com.sdd.interbanking.model.recaudador;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown = true)
public class Respuesta {

    private String codigo;
    private String descripcion;

    public String getCodigo() {
        return codigo;
    }

    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }

    public String getDescripcion() {
        return descripcion;
    }

    public void setDescripcion(String descripcion) {
        this.descripcion = descripcion;
    }

    @Override
    public String toString() {
        return "Respuesta ["
                + ((codigo != null) ? "codigo=" + codigo + ", " : "")
                + ((descripcion != null) ? "descripcion=" + descripcion : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Respuesta respuesta = (Respuesta) o;

        if (codigo != null ? !codigo.equals(respuesta.codigo) : respuesta.codigo != null) return false;
        return descripcion != null ? descripcion.equals(respuesta.descripcion) : respuesta.descripcion == null;
    }

    @Override
    public int hashCode() {
        int result = codigo != null ? codigo.hashCode() : 0;
        result = 31 * result + (descripcion != null ? descripcion.hashCode() : 0);
        return result;
    }
}
