package ar.com.sdd.interbanking.core;

import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import ar.com.sdd.commons.rest.model.TokenOAuth2Refresh;
import ar.com.sdd.commons.rest.util.QueryBuilder;
import ar.com.sdd.interbanking.io.financiero.*;
import ar.com.sdd.interbanking.model.financiero.ErrorMessage;
import ar.com.sdd.interbanking.util.StringUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Form;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/*
*  IB tiene tres modelos de conexion, a medidda que fue evolucionando
*  1) apiKey       : version inicial, se usa para publicar deuda y consultar pagos
*  2) certificado  : version primera de MBO usandoautenticacion x certificados
*  3) token       : version actual de MBO usando autenticacion x token
*
*  La 1 esta se usa desde InterbankingApiKey
*      Se usa para publicar deuda y consultar pagos para el modelo de publicacion de deuda
*      Se uso temporalmente para la implementacion del modelo TPNAPI, que en vez
*      de generar un pago BtoB, directamente, generaba una publiacciaon de deuda y luego
*      remite al cliente a pagarla
*      Este modelo lo expejamos en ar.com.sdd.ebfapi.client.model.contrato.inba para poder exponer los mismos servicios
*      que IB, para que los use CVSA
*      El model que usamos como cliente de IB, ahora esta bajo recaudaror.*
*
*  La 2 desde InterbankingApiCertificateConnector
*      El modelo asociado esta bajo financiero_v1
*
*  La 3 es la que deberia sobrevivir a largo plazo
*      El modelo asociado esta bajco financiero
*
*
*  Esta clase es un ancestro comun para poder usar en los metodos mas genrales
*
*/

@SuppressWarnings("unused")
public abstract class InterbankingApiBaseConnector implements RestSecurityManager {

    public enum ConnectorClass {
        CERTIFICATE,
        TOKEN,
        APIKEY
    }
    public abstract ConnectorClass getConnectorClass();
}
